/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.service;

import cn.hutool.core.util.RandomUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.utils.CommonsUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IEmailProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISmsProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserInfoProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.PhoneCodeToken;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.UsernamePasswordToken;
import com.wf.captcha.SpecCaptcha;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private IUserInfoProviderService userInfoProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ISmsProviderService smsProviderService;
    @DubboReference
    private IEmailProviderService emailProviderService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final TokenService tokenService;

    public boolean sendLoginCode(String phone) {
        return true;
    }

    public boolean sendEmailCode(String email) {
        if (this.userProviderService.getOneByEmail(email) == null) {
            throw new ServiceException("\u90ae\u7bb1\u4e0d\u5b58\u5728\uff01");
        }
        String code = RandomUtil.randomStringUpper((int)6);
        String text = String.format("\u60a8\u7684\u9a8c\u8bc1\u7801\uff1a%s\uff0c5\u5206\u949f\u5185\u6709\u6548\uff01", code);
        this.emailProviderService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword((String)code, (String)email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey((String)email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public boolean sendRegisterEmailCode(String email) {
        String code = RandomUtil.randomStringUpper((int)6);
        String text = String.format("\u60a8\u7684\u9a8c\u8bc1\u7801\uff1a%s\uff0c5\u5206\u949f\u5185\u6709\u6548\uff01", code);
        this.emailProviderService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword((String)code, (String)email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey((String)email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public String sendVcode(String key) {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 4);
        String code = specCaptcha.text().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey((String)key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.toBase64();
    }

    public LoginData loginByPassword(String phone, String password, Integer userType) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(phone, password, userType);
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u624b\u673a\u53f7or\u8d26\u53f7\u5bc6\u7801\u767b\u9646\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginData loginByCode(String phone, String code) {
        Subject subject = SecurityUtils.getSubject();
        PhoneCodeToken token = new PhoneCodeToken(phone, code);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            return this.returnLoginInitParam(principal);
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u624b\u673a\u53f7or\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginData loginByCas(CasToken token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u76d1\u7ba1cas\u767b\u9646\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public void modifyPasswordByEmail(String email, String code, String password) {
        Object emailCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey((String)email));
        if (Objects.isNull(emailCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)email);
        if (!Objects.equals(emailCode, encryptCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.userProviderService.modifyPasswordByEmail(email, password);
    }

    public LoginData returnLoginInitParam(ShiroPrincipal principal) {
        this.tokenService.doGetAuthorizationInfo(principal);
        if (Objects.equals(principal.getUserType(), SysUserTypeEnum.USER.getValue())) {
            principal.setUserInfo(this.userInfoProviderService.getUserInfo(principal.getUserId()));
        } else {
            UserCropVo userVo = this.userCropProviderService.getFullUserInfo(principal.getUserId());
            HseCompanyVo vo = this.hseCompanyProviderService.getInfoById(userVo.getCid());
            CompanyInfo companyInfo = new CompanyInfo();
            companyInfo.setId(vo.getId());
            companyInfo.setName(vo.getName());
            companyInfo.setCreditCode(vo.getUnifiedSocialCc());
            companyInfo.setContactTel(vo.getCompanyContactTel());
            companyInfo.setContact(vo.getOccManagerName());
            companyInfo.setAreaId(vo.getAreaId());
            companyInfo.setAreaAddress(vo.getRegisterAddress());
            companyInfo.setIndustryCode(String.valueOf(vo.getIndustryCategory()));
            companyInfo.setBelongType(vo.getBelongType());
            principal.setCompanyInfo(companyInfo);
        }
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String name = principal.getUser().getName();
        String ip = ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = this.getTokenSecret(userId, principal.getUser().getPassword());
        String token = JwtUtil.createToken((String)username, (Long)userId, (String)name, (String)ip, (String)secret, (Long)Constant.TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken((String)username, (Long)userId, (String)secret, (Long)Constant.TOKEN_REFRESH_TIME);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getLoginUserKey((Long)userId), (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)userId), (Object)secret, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
        ShiroPrincipal principalDesensitization = ShiroUtil.getShiroPrincipalDesensitization(principal);
        return new LoginData(principalDesensitization, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        Long userId = JwtUtil.getUserId((String)refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u8fc7\u671f\uff01");
        }
        SysUser user = this.userProviderService.selectUserById(userId);
        if (user == null) {
            throw new ServiceException(Integer.valueOf(-1), "\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.getTokenSecret(userId, user.getPassword());
        if (!JwtUtil.verify((String)refreshToken, (String)secret)) {
            throw new ServiceException(Integer.valueOf(-1), "token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)user.getName(), (String)ip, (String)secret, (Long)Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)secret, (Long)Constant.TOKEN_REFRESH_TIME);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)user.getId()), (Object)secret, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
        return new LoginData(newToken, newRefreshToken);
    }

    private String getTokenSecret(Long userId, String password) {
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getTokenSecret((Long)userId));
        if (secret == null) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)userId), (Object)password, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
            return password;
        }
        return secret;
    }

    public boolean checkEmailCode(String email, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey((String)email));
        if (Objects.isNull(modifyCode)) {
            log.info("checkEmailCode: email:{}", (Object)email);
            throw new ServiceException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)email);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkVcode(String key, String vcode, boolean isDelete) {
        Object vodeCache = null;
        if (isDelete) {
            vodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey((String)key));
            this.stringRedisTemplate.delete((Object)RedisKey.getVCodeKey((String)key));
        } else {
            vodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey((String)key));
        }
        if (Objects.isNull(vodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode.equalsIgnoreCase(vodeCache.toString());
    }

    @Generated
    public LoginService(StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, TokenService tokenService) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.tokenService = tokenService;
    }
}

