/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.filter;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);
    private final StringRedisTemplate stringRedisTemplate;
    private final String profiles;

    public JwtFilter(StringRedisTemplate stringRedisTemplate, String profiles) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.profiles = profiles;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return StrUtil.isNotEmpty((CharSequence)this.getAuthorization((HttpServletRequest)request));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            return this.executeLogin(request, response);
        }
        return false;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (JwtUtil.isTokenExpired((String)token).booleanValue()) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.TOKEN_EXPIRED.getValue(), ResponseStateEnum.TOKEN_EXPIRED.getName()), response);
            return false;
        }
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getTokenSecret((Long)JwtUtil.getUserId((String)token)));
        if (StringUtils.isEmpty((CharSequence)secret)) {
            secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getAdminTokenSecret((Long)JwtUtil.getUserId((String)token)));
        }
        if (!JwtUtil.verify((String)token, (String)secret)) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName()), response);
            return false;
        }
        BearerToken bearerToken = new BearerToken(token);
        try {
            this.getSubject(request, response).login((AuthenticationToken)bearerToken);
        }
        catch (AuthenticationException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), ResponseStateEnum.UNAUTHORIZED.getName()), response);
            return false;
        }
        catch (AuthorizationException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.FORBIDDEN.getValue(), ResponseStateEnum.FORBIDDEN.getName()), response);
            return false;
        }
        catch (Exception e) {
            log.error("jwt-Exception\uff1a", (Throwable)e);
            this.returnErr((ResponseData<Object>)new ResponseData((Object)ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue()), response);
            return false;
        }
        return true;
    }

    private String getAuthorization(HttpServletRequest httpRequest) {
        String authorization = httpRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isEmpty((CharSequence)authorization)) {
            authorization = httpRequest.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return authorization;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)JSON.toJSONString(data));
    }
}

