/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.interceptor;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import com.sx.log.util.LogUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class BigDataLogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BigDataLogInterceptor.class);
    private final SysProperties sysProperties;
    private final IBigDataLogProviderService bigDataLogProviderService;

    public BigDataLogInterceptor(SysProperties sysProperties, IBigDataLogProviderService bigDataLogProviderService) {
        this.sysProperties = sysProperties;
        this.bigDataLogProviderService = bigDataLogProviderService;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        BigLog bigLog = method.getAnnotation(BigLog.class);
        if (bigLog == null) {
            return;
        }
        Long userId = ShiroUtil.getLoginUserId();
        Long regionId = ShiroUtil.getLoginAreaId();
        if (userId == null || regionId == null) {
            return;
        }
        String businessIdParamName = bigLog.businessIdParamName();
        String businessId = request.getParameter(businessIdParamName);
        if (CharSequenceUtil.isBlank((CharSequence)businessId)) {
            String requestURI = request.getRequestURI();
            String[] split = requestURI.split("/");
            businessId = split[split.length - 1];
        }
        String areaCode = Convert.toStr((Object)regionId).substring(0, Math.min(Convert.toStr((Object)regionId).length(), 9));
        ActionTypeEnum actionType = bigLog.actionType();
        String actionId = actionType == ActionTypeEnum.LOGIN_TYPE ? "" : bigLog.businessModule().getValue().concat(businessId);
        UserRoleEnum userRole = bigLog.userRole();
        this.bigDataLogProviderService.handleBigDataLog(actionType, userRole, actionId, userId, areaCode, this.sysProperties.getBigDataLogAppCode());
        switch (actionType) {
            case LOGIN_TYPE: {
                LogUtils.login((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode);
                break;
            }
            case WORK_START_TYPE: {
                LogUtils.workStart((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                break;
            }
            case WORK_END_TYPE: {
                LogUtils.workEnd((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                break;
            }
        }
    }
}

