/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.user;

import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IMsgProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.User;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e2a\u4eba-\u4e2a\u4eba\u4e2d\u5fc3"})
@ApiSupport(order=31, author="\u5434\u5c0f\u5f3a")
@RestController
@RequestMapping(value={"/personal/uc"})
@Validated
public class PersonalCenterController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonalCenterController.class);
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysParamProviderService sysParamProviderService;
    @DubboReference
    private IMsgProviderService msgProviderService;

    @ApiOperation(value="\u5f53\u524d\u8d26\u53f7\u4fe1\u606f")
    @PostMapping(value={"/getPersonalInfo"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="isBrief", value="\u662f\u5426\u83b7\u53d6\u7b80\u7565\u4fe1\u606f", required=false, dataTypeClass=Boolean.class)})
    public ResponseData<PersonalUserVo> getPersonalInfo(@RequestParam(required=false) Boolean isBrief) {
        PersonalUserVo personalUserInfo;
        if ((isBrief = Boolean.valueOf(isBrief == null || isBrief != false)).booleanValue()) {
            User user = ShiroUtil.getShiroPrincipal().getUser();
            UserInfo userInfo = ShiroUtil.getShiroPrincipal().getUserInfo();
            personalUserInfo = new PersonalUserVo();
            personalUserInfo.setId(user.getId()).setUserType(Integer.valueOf(1)).setName(user.getName()).setEmail(user.getEmail()).setAvatar(user.getAvatar());
            SysParam education = null;
            SysParam workType = null;
            if (userInfo.getEducation() != null) {
                education = this.sysParamProviderService.getByCode(userInfo.getEducation());
            }
            if (userInfo.getEducation() != null) {
                workType = this.sysParamProviderService.getByCode(userInfo.getWorkType());
            }
            personalUserInfo.setPhotoUrl(userInfo.getPhotoUrl()).setEducation(userInfo.getEducation()).setEducationStr(education == null ? null : education.getName()).setWorkType(userInfo.getWorkType()).setWorkTypeStr(workType == null ? null : workType.getName()).setRadiationWorkDate(userInfo.getRadiationWorkDate()).setIdcard(userInfo.getIdcard());
            personalUserInfo.setUnreadMsgNum(this.msgProviderService.getUnreadMsgNum(user.getId()));
        } else {
            personalUserInfo = this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId());
        }
        personalUserInfo.setIsBrief(isBrief);
        return ResponseData.success((Object)personalUserInfo);
    }

    @PostMapping(value={"/editUser"})
    @ApiOperation(value="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599")
    public ResponseData<String> editUser(@RequestBody EditUserParam editUserParam) {
        try {
            this.userProviderService.editPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            log.error("Exception\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @ApiOperationSupport(order=20)
    @ApiOperation(value="\u66f4\u65b0\u5934\u50cf")
    @PostMapping(value={"/updateHeadImg"})
    public ResponseData updateHeadImg(@RequestBody UpdateHeadImgParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        this.userProviderService.updateHeadImg(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u653e\u5c04\u5de5\u4f5c\u9879\u76ee \u4e0b\u62c9\u6570\u636e")
    @GetMapping(value={"getWorkTypeList"})
    public ResponseData<List<SysParamVo>> getTrainingWorkType() {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(new ParamQueryParam().setPcode("100").setIsForbidden(Integer.valueOf(0))));
    }

    @ApiOperation(value="\u5b66\u5386 \u4e0b\u62c9\u6570\u636e")
    @GetMapping(value={"getEducations"})
    public ResponseData<List<SysParamVo>> getEducations() {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(new ParamQueryParam().setPcode("104").setIsForbidden(Integer.valueOf(0))));
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801-\u5bfc\u5165\u540e\u672a\u4fee\u6539\u5bc6\u7801\u7684")
    @ApiImplicitParams(value={@ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password) {
        this.userProviderService.modifyPassword(ShiroUtil.getLoginUserId(), password);
        return ResponseData.success();
    }

    @ApiOperation(value="\u901a\u8fc7\u65e7\u5bc6\u7801\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPassword) {
        this.userProviderService.modifyPasswordByOldPwd(ShiroUtil.getLoginUserId(), oldPassword, newPassword);
        return ResponseData.success();
    }

    @Generated
    public PersonalCenterController() {
    }
}

