/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.corp;

import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropDeleteOneEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveStaffParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchRegListParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchStaffTrainingDetailParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SendBackParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CorpMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForCorp;
import cn.smarthse.radiationTraining.modules.training.vo.course.EnrollInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.StaffTrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CorpMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CropTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.www.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57f9\u8bad\u7ba1\u7406(\u5355\u4f4d\u7528\u6237)"})
@ApiSupport(order=20, author="\u891a\u6d77\u6d0b\u3001\u9648\u4eae")
@RestController
@RequestMapping(value={"/crop/train"})
public class CorpTrainingController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderServiceForCorp iTrainingProviderServiceForCorp;
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;

    @ApiOperation(value="\u67e5\u770b\u767b\u9646\u540e-\u9996\u9875\u57f9\u8bad\u7ba1\u7406\u5217\u8868")
    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getTrainingList(TrainingSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        Integer userType = ShiroUtil.getShiroPrincipal().getUserType();
        if (Objects.equals(userType, SysUserTypeEnum.COMPANY.getValue())) {
            param.setTrainTarget(Integer.valueOf(0));
        }
        param.setCid(companyInfo.getId());
        param.setAreaId(companyInfo.getAreaId());
        param.setBelongType(companyInfo.getBelongType());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingPageListForCorp(param));
    }

    @ApiOperation(value="\u67e5\u770b\u4e2a\u4eba\u4e2d\u5fc3-\u5404\u57f9\u8bad\u72b6\u6001\u7684\u6570\u91cf(\u5bfc\u822a\u680f)")
    @ApiImplicitParam(name="trainTargetType", value="\u57f9\u8bad\u5bf9\u8c61\u7c7b\u578b(0-\u7528\u4eba\u5355\u4f4d\u57f9\u8bad; 1-\u673a\u6784\u57f9\u8bad; 2-\u653e\u5c04\u536b\u751f\u57f9\u8bad)")
    @GetMapping(value={"getTrainingStatusNumList"})
    public ResponseData<List<CropTrainStatusNumVo>> getTrainingStatusNumList(Integer trainTargetType) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingStatusNumListForCrop(companyInfo.getId(), trainTargetType));
    }

    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getTrainingBaseInfo(TrainingSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        param.setCid(companyInfo.getId());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingBaseInfoForCorp(param));
    }

    @ApiOperation(value="\u67e5\u770b\u767b\u9646\u540e-\u9996\u9875\u57f9\u8bad\u8be6\u60c5-\u8bfe\u7a0b\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId")})
    @GetMapping(value={"getTrainingCourseGroup"})
    public ResponseData<List<TrainingCourseGroupVo>> getTrainingCourseGroup(Long tid) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingCourseGroupForCorp(tid, companyInfo.getId()));
    }

    @ApiOperation(value="\u67e5\u770b\u767b\u9646\u540e-\u9996\u9875\u57f9\u8bad\u8be6\u60c5-\u8bfe\u7a0b\u7ec4-\u8bfe\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId"), @ApiImplicitParam(name="trainCourseGroupId", value="\u57f9\u8bad\u8bfe\u7a0b\u7ec4Id")})
    @GetMapping(value={"getTrainingCourse"})
    public ResponseData<List<TrainingCourseVo>> getTrainingCourse(Long tid, Long trainCourseGroupId) {
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingCourseForCorp(tid, trainCourseGroupId));
    }

    @ApiOperation(value="\u67e5\u770b\u5355\u4f4d\u7528\u6237\u4e2d\u5fc3-\u57f9\u8bad\u7ba1\u7406\u5217\u8868")
    @GetMapping(value={"getMyTrainingList"})
    public ResponseData<LayuiGridData<CorpMyTrainListVo>> getMyTrainingList(CorpMyTrainSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        param.setCid(companyInfo.getId());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getMyTrainPageListForCorp(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5df2\u62a5\u540d\u57f9\u8bad\u7684\u5de5\u4f5c\u7c7b\u522b")
    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType() {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingWorkType(companyInfo.getId()));
    }

    @ApiOperationSupport(order=100)
    @ApiOperation(value="\u6211\u7684\u57f9\u8bad-\u57f9\u8bad\u62a5\u540d\u6e05\u5355-\u641c\u7d22")
    @GetMapping(value={"searchEnrollList"})
    public ResponseData<LayuiGridData<EnrollInfoVo>> searchEnrollList(SearchRegListParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        return ResponseData.success((Object)this.enrollProviderService.searchEnrollList(param));
    }

    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u6211\u7684\u57f9\u8bad-\u57f9\u8bad\u62a5\u540d\u6e05\u5355-\u9000\u56de\uff08\u5e9f\u5f03\uff09")
    @Log(title="\u62a5\u540d\u6e05\u5355-\u9000\u56de\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"sendBack"})
    public ResponseData sendBack(@RequestBody SendBackParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToSendBack(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=300)
    @ApiOperation(value="\u6211\u7684\u57f9\u8bad-\u57f9\u8bad\u62a5\u540d\u6e05\u5355-\u5220\u9664")
    @Log(title="\u62a5\u540d\u6e05\u5355-\u5220\u9664\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteStaff"})
    public ResponseData deleteStaff(@RequestBody RemoveStaffParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToDeleteStaff(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=400)
    @ApiOperation(value="\u6211\u7684\u57f9\u8bad-\u57f9\u8bad\u62a5\u540d\u6e05\u5355-\u6279\u91cf\u5220\u9664")
    @Log(title="\u62a5\u540d\u6e05\u5355-\u6279\u91cf\u5220\u9664\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteStaffBatch"})
    public ResponseData deleteStaffBatch(@RequestBody List<RemoveStaffParam> paramList) {
        Long cid = ShiroUtil.getShiroPrincipal().getCompanyInfo().getId();
        for (RemoveStaffParam v : paramList) {
            v.setCid(cid);
            v.setLoginUserId(ShiroUtil.getLoginUserId());
            v.setLoginUsername(ShiroUtil.getLoginUsername());
        }
        this.enrollProviderService.cropTodeleteStaffBatch(paramList);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=500)
    @ApiOperation(value="\u6211\u7684\u57f9\u8bad-\u57f9\u8bad\u62a5\u540d\u6e05\u5355-\u67e5\u770b\u8be6\u60c5")
    @GetMapping(value={"getStaffTrainingDetail"})
    public ResponseData<LayuiGridData<StaffTrainingDetailVo>> getStaffTrainingDetail(SearchStaffTrainingDetailParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        return ResponseData.success((Object)this.enrollProviderService.getStaffTrainingDetail(param));
    }

    @ApiOperationSupport(order=600)
    @ApiOperation(value="\u67e5\u770b\u5355\u4f4d\u7528\u6237\u4e2d\u5fc3-\u57f9\u8bad\u7ba1\u7406\u5217\u8868-\u5220\u9664")
    @Log(title="\u5355\u4f4d\u7528\u6237\u4e2d\u5fc3-\u5220\u9664\u5355\u4f4d\u62a5\u540d", logModule=LogModuleTypeEnum.unit_enroll_crop, type=LogTypeEnum.type_opt_del)
    @GetMapping(value={"cropToDeleteOneEnroll"})
    public ResponseData cropToDeleteOneEnroll(CropDeleteOneEnrollParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToDeleteOneEnroll(param);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
    }
}

