/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.api;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.uploader.FileResourceEnum;
import cn.smarthse.radiationTraining.core.framework.uploader.FileUploadSimple;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFileParameter;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.www.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@ApiSupport(order=2, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u516c\u5171\u6a21\u5757-\u6587\u4ef6\u4e0a\u4f20\u4e0b\u8f7d"})
@Controller
@RequestMapping(value={"/api/file"})
public class FileUploadController
extends ControllerSupport {
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private final OssClientBean ossClientBean;
    private final SysProperties sysProperties;

    @ApiOperation(value="\u901a\u8fc7Form\u4e0a\u4f20\u9644\u4ef6")
    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=LogTypeEnum.type_opt_upload)
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<SysFileModel> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileModel existSysFile = this.sysFileProvideService.getFileByHash(hashCode);
        if (existSysFile != null) {
            existSysFile.setFullOssUrl(this.ossClientBean.getUrl(existSysFile.getFullOssUrl()));
            return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        String originalFilename = fileData.getOriginalFilename();
        List split = StrUtil.split((CharSequence)originalFilename, (CharSequence)".");
        if (split.size() != 2) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u53ef\u5305\u542b\u591a\u4e2a'.'\u7b26\u53f7\uff01");
        }
        String fileNameExExt = (String)split.get(0);
        if (StrUtil.isBlank((CharSequence)(fileNameExExt = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)fileNameExExt))))) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01");
        }
        originalFilename = fileNameExExt + "." + (String)split.get(1);
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + UUID.randomUUID() + "-" + originalFilename;
        String res = this.ossClientBean.OSSPutObject(uploadFile, originalFilename, fileData.getInputStream());
        SysFileModel file = new SysFileModel();
        file.setFileName(originalFilename);
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(type);
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file.setOssUrl(res);
        file = this.sysFileProvideService.addSysFile(file, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)file);
    }

    @ApiOperation(value="\u83b7\u53d6OSS\u76f4\u4f20\u7b7e\u540d", hidden=true)
    @ResponseBody
    @RequestMapping(value={"postSignature"}, method={RequestMethod.GET})
    public Map<String, String> postSignature() throws Exception {
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();
        return this.ossClientBean.getPostSignature(uploadDir);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u9644\u4ef6MD5\u7801", hidden=true)
    @ResponseBody
    @RequestMapping(value={"check/{filehash}"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> checkfilemd5(@PathVariable(value="filehash") String filehash) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011->\u3010\u9a8c\u8bc1{}\u3011", (Object)filehash);
        SysFileModel record = this.sysFileProvideService.getFileByHash(filehash);
        ResponseData data = new ResponseData();
        if (record != null) {
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.success);
        } else {
            data.setState(ResponseStateEnum.fail);
        }
        return data;
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u4e0b\u8f7d\u9644\u4ef6")
    @RequestMapping(value={"download/{fileid}"}, method={RequestMethod.GET})
    public String fileDownload(@PathVariable Long fileid) {
        if (fileid == null) {
            return "";
        }
        SysFileModel f = this.sysFileProvideService.getFileById(fileid);
        return "redirect:" + f.getFullOssUrl();
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id")})
    @RequestMapping(value={"getFileUrl"}, method={RequestMethod.POST})
    public ResponseData<String> getFileUrl(Long fileId) {
        this.logger.info("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        if (fileId == null) {
            data.setResult((Object)"");
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (file != null) {
            data.setResult((Object)file.getFullOssUrl());
            data.setMessage("\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail);
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id")})
    @RequestMapping(value={"getFile"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> getFile(Long fileId) {
        this.logger.info("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        if (fileId == null) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (file != null) {
            data.setResult((Object)file);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail);
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileIds", value="\u6587\u4ef6ids(\u9017\u53f7\u9694\u5f00)")})
    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST})
    public ResponseData<List<SysFileModel>> getFileList(String fileIds) {
        this.logger.info("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408, fileIds={}", (Object)fileIds);
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        List list = this.sysFileProvideService.getListByIds(fileIds);
        if (list != null && !list.isEmpty()) {
            data.setResult((Object)list);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail);
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @Generated
    public FileUploadController(OssClientBean ossClientBean, SysProperties sysProperties) {
        this.ossClientBean = ossClientBean;
        this.sysProperties = sysProperties;
    }
}

