/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.HttpClientUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.UserLoginWeixin;
import cn.smarthse.radiationTraining.modules.sys.service.user.IUserLoginWeixinService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.properties.WxOpenProperties;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.www.controller.ControllerSupport;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u767b\u5f55-\u5fae\u4fe1\u767b\u5f55\u63a5\u53e3"}, hidden=true)
@Controller
@RequestMapping(value={"/wx"})
public class WXLoginController
extends ControllerSupport {
    private final WxOpenProperties wxOpenProperties;
    private final LoginService loginService;
    @DubboReference
    private IUserLoginWeixinService userLoginWeixinService;

    @ApiOperation(value="1.\u751f\u6210\u5fae\u4fe1\u767b\u5f55\u4e8c\u7ef4\u7801\uff0c\u5fae\u4fe1\u670d\u52a1\u5668\u4f1a\u56de\u8c03\u5230callback\u63a5\u53e3")
    @ResponseBody
    @GetMapping(value={"login"})
    public String getWxCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String baseUrl = "https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_login&state=%s#wechat_redirect";
        String redirectUrl = URLEncoder.encode(this.wxOpenProperties.getRedirect_url(), "utf-8");
        return String.format(baseUrl, this.wxOpenProperties.getApp_id(), redirectUrl, "smarthse");
    }

    @ResponseBody
    @GetMapping(value={"callback"})
    public ResponseData<LoginData> callback(String code, String state, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("callback-code:{}-state:{}", (Object)code, (Object)state);
        try {
            Map<String, Object> access_map = this.access_token(code, state);
            String access_token = (String)access_map.get("access_token");
            String openid = (String)access_map.get("openid");
            if (StringUtils.isBlank((CharSequence)access_token)) {
                return ResponseData.fail((String)"\u5fae\u4fe1\u6388\u6743\u8fc7\u671f\uff01");
            }
            UserLoginWeixin userLoginWeixin = this.getUserinfo(access_token, openid);
            SysUser user = this.userLoginWeixinService.saveUserLoginWeixin(userLoginWeixin);
            BearerToken token = new BearerToken(JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), null, (Long)Constant.TOKEN_EXPIRE_TIME));
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            return ResponseData.success((Object)this.loginService.returnLoginInitParam(principal));
        }
        catch (Exception e) {
            this.logger.error("Exception\uff1a", (Throwable)e);
            return ResponseData.fail(null);
        }
    }

    private Map<String, Object> access_token(String code, String state) throws Exception {
        String baseAccessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
        String accessTokenUrl = String.format(baseAccessTokenUrl, this.wxOpenProperties.getApp_id(), this.wxOpenProperties.getApp_secret(), code);
        String accessTokenInfo = HttpClientUtils.get((String)accessTokenUrl);
        Gson gson = new Gson();
        Map mapAccessToken = (Map)gson.fromJson(accessTokenInfo, Map.class);
        String access_token = (String)mapAccessToken.get("access_token");
        String refresh_token = (String)mapAccessToken.get("refresh_token");
        String openid = (String)mapAccessToken.get("openid");
        String scope = (String)mapAccessToken.get("scope");
        String unionid = (String)mapAccessToken.get("unionid");
        this.logger.debug("access_token:{}", (Object)access_token);
        this.logger.debug("refresh_token:{}", (Object)refresh_token);
        this.logger.debug("openid:{}", (Object)openid);
        this.logger.debug("scope:{}", (Object)scope);
        this.logger.debug("unionid:{}", (Object)unionid);
        return mapAccessToken;
    }

    private UserLoginWeixin getUserinfo(String access_token, String openid) throws Exception {
        this.logger.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55\u4fe1\u606f");
        String baseUserInfoUrl = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s";
        String userInfoUrl = String.format(baseUserInfoUrl, access_token, openid);
        String userInfo = HttpClientUtils.get((String)userInfoUrl);
        HashMap userInfoMap = (HashMap)new Gson().fromJson(userInfo, HashMap.class);
        UserLoginWeixin userLoginWeixin = new UserLoginWeixin();
        userLoginWeixin.setOpenId((String)userInfoMap.get("openid"));
        userLoginWeixin.setNickname((String)userInfoMap.get("nickname"));
        userLoginWeixin.setSex(((Double)userInfoMap.get("sex")).intValue() + "");
        userLoginWeixin.setProvince((String)userInfoMap.get("province"));
        userLoginWeixin.setCity((String)userInfoMap.get("city"));
        userLoginWeixin.setHeadimgurl((String)userInfoMap.get("headimgurl"));
        userLoginWeixin.setUnionid((String)userInfoMap.get("unionid"));
        return userLoginWeixin;
    }

    @Generated
    public WXLoginController(WxOpenProperties wxOpenProperties, LoginService loginService) {
        this.wxOpenProperties = wxOpenProperties;
        this.loginService = loginService;
    }
}

