/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.realms;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.PhoneCodeToken;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.User;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class CodeRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeRealm.class);
    @DubboReference(check=false)
    private IUserProviderService userService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public boolean supports(AuthenticationToken token) {
        return token instanceof PhoneCodeToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        Object credentials;
        PhoneCodeToken token = (PhoneCodeToken)authenticationToken;
        log.info("{} - code auth start...", (Object)token.getPhone());
        SysUser user = this.userService.selectUserByPhone(token.getPhone());
        if (ObjectUtil.isNull((Object)user)) {
            this.userService.register(token.getPhone(), new String[0]);
        }
        if ((credentials = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getLoginCodeKey((String)user.getPhone()))) == null) {
            throw new ExpiredCredentialsException();
        }
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((String)token.getPhone());
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(new User(user)), credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

