/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.bootstrap.security.filter;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);
    private final StringRedisTemplate stringRedisTemplate;
    private final String profiles;
    private static final SerializeConfig CONFIG = new SerializeConfig();

    public JwtFilter(StringRedisTemplate stringRedisTemplate, String profiles) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.profiles = profiles;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return StrUtil.isNotEmpty((CharSequence)this.getAuthorization((HttpServletRequest)request));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            return this.executeLogin(request, response);
        }
        return false;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (JwtUtil.isTokenExpired((String)token).booleanValue()) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getTokenSecret((Long)JwtUtil.getUserId((String)token)));
        if (StringUtils.isEmpty((CharSequence)secret)) {
            secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getAdminTokenSecret((Long)JwtUtil.getUserId((String)token)));
        }
        if (!JwtUtil.verify((String)token, (String)secret)) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u975e\u6cd5\u7b7e\u540d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        BearerToken bearerToken = new BearerToken(token);
        try {
            this.getSubject(request, response).login((AuthenticationToken)bearerToken);
        }
        catch (IncorrectCredentialsException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (AuthenticationException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.Unauthorized403, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (Exception e) {
            log.error("IOException\uff1a", (Throwable)e);
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.INTERNAL_SERVER_ERROR), response);
            return false;
        }
        return true;
    }

    private String getAuthorization(HttpServletRequest httpRequest) {
        String authorization = httpRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isEmpty((CharSequence)authorization)) {
            authorization = httpRequest.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return authorization;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)JSON.toJSONString(data, (SerializeConfig)CONFIG, (SerializerFeature[])new SerializerFeature[0]));
    }

    static {
        CONFIG.configEnumAsJavaBean(new Class[]{ResponseStateEnum.class});
    }
}

