/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.utils;

import cn.hutool.core.date.Week;
import cn.smarthse.radiationTraining.core.framework.utils.DateStyle;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.github.pagehelper.util.StringUtil;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_FORMAT_DEFAULT = "HH:mm:ss";
    public static final String DATE_FORMAT_YMD = "yyyy-MM-dd";
    private static final String[] zodiacArr = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final String[] constellationArr = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u7261\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    private static final int[] constellationEdgeDay = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
    private static String[] weeks = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static String getDate() {
        return DateUtils.getDate(DATE_FORMAT_YMD);
    }

    public static String format(java.util.Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return DateFormatUtils.format((java.util.Date)date, (String)pattern);
    }

    public static String formatDate(java.util.Date date) {
        return DateUtils.format(date, DATE_FORMAT_YMD);
    }

    public static String formatDateTime(java.util.Date date) {
        return DateUtils.format(date, DATE_FORMAT_DEFAULT);
    }

    public static String formatDateWithWeek(java.util.Date date) {
        if (date == null) {
            return "";
        }
        String d = DateUtils.format(date, "yyyy/MM/dd HH:mm");
        String week = weeks[Math.abs(DateUtils.getWeekByDate(date))];
        return d + " \u5468" + week;
    }

    public static String formatDateForWeibo(java.util.Date date) {
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int dateYear = Integer.parseInt(new SimpleDateFormat("yyyy").format(date));
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append("\u521a\u521a");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else if (dateYear != year) {
            buffer.append(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm").format(date));
        } else {
            buffer.append(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static String getTime() {
        return DateUtils.format(new java.util.Date(), TIME_FORMAT_DEFAULT);
    }

    public static String getDateTime() {
        return DateUtils.format(new java.util.Date(), DATE_FORMAT_DEFAULT);
    }

    public static String getYear() {
        return DateUtils.format(new java.util.Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.format(new java.util.Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.format(new java.util.Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.format(new java.util.Date(), "E");
    }

    public static java.util.Date parseDate(Object str) {
        if (str == null || StringUtils.isEmpty((CharSequence)str.toString())) {
            return null;
        }
        try {
            str = str.toString().trim();
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(java.util.Date date) {
        long t = new java.util.Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(java.util.Date date) {
        long t = new java.util.Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(java.util.Date date) {
        long t = new java.util.Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (String)(day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(java.util.Date before, java.util.Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static long getDistanceOfTodayDate(java.util.Date after) {
        long beforeTime = System.currentTimeMillis();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        if (dateFormat == null) {
            Object object = DateUtils.object;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(pattern);
                    dateFormat.setLenient(false);
                    threadLocal.set(dateFormat);
                }
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    private static int getInteger(java.util.Date date, int dateType) {
        int num = 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
            num = calendar.get(dateType);
        }
        return num;
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        if (dateStyle != null) {
            java.util.Date myDate = DateUtils.StringToDate(date, dateStyle);
            myDate = DateUtils.addInteger(myDate, dateType, amount);
            dateString = DateUtils.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static java.util.Date addInteger(java.util.Date date, int dateType, int amount) {
        java.util.Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static java.util.Date getAccurateDate(List<Long> timestamps) {
        java.util.Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                    for (int i = 1; i < absoluteValues.size(); ++i) {
                        if (minAbsoluteValue <= (Long)absoluteValues.get(i)) continue;
                        minAbsoluteValue = (Long)absoluteValues.get(i);
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    long dateOne = timestampsLastTmp[0];
                    long dateTwo = timestampsLastTmp[1];
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.abs(dateOne) > Math.abs(dateTwo) ? dateOne : dateTwo;
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new java.util.Date(timestamp);
        }
        return date;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            if (style.isShowOnly()) continue;
            java.util.Date dateTmp = null;
            if (date != null) {
                try {
                    ParsePosition pos = new ParsePosition(0);
                    dateTmp = DateUtils.getDateFormat(style.getValue()).parse(date, pos);
                    if (pos.getIndex() != date.length()) {
                        dateTmp = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        java.util.Date accurateDate = DateUtils.getAccurateDate(timestamps);
        if (accurateDate != null) {
            dateStyle = (DateStyle)((Object)map.get(accurateDate.getTime()));
        }
        return dateStyle;
    }

    public static java.util.Date StringToDate(String date) {
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToDate(date, dateStyle);
    }

    public static java.util.Date StringToDate(String date, String pattern) {
        java.util.Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtils.getDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static java.util.Date StringToDate(String date, DateStyle dateStyle) {
        java.util.Date myDate = null;
        if (dateStyle != null) {
            myDate = DateUtils.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(java.util.Date date, String pattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtils.getDateFormat(pattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(java.util.Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtils.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String newPattern) {
        DateStyle oldDateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToString(date, oldDateStyle, newPattern);
    }

    public static String StringToString(String date, DateStyle newDateStyle) {
        DateStyle oldDateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToString(date, oldDateStyle, newDateStyle);
    }

    public static String StringToString(String date, String olddPattern, String newPattern) {
        return DateUtils.DateToString(DateUtils.StringToDate(date, olddPattern), newPattern);
    }

    public static String StringToString(String date, DateStyle olddDteStyle, String newParttern) {
        String dateString = null;
        if (olddDteStyle != null) {
            dateString = DateUtils.StringToString(date, olddDteStyle.getValue(), newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, String olddPattern, DateStyle newDateStyle) {
        String dateString = null;
        if (newDateStyle != null) {
            dateString = DateUtils.StringToString(date, olddPattern, newDateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle != null && newDateStyle != null) {
            dateString = DateUtils.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtils.addInteger(date, 1, yearAmount);
    }

    public static java.util.Date addYear(java.util.Date date, int yearAmount) {
        return DateUtils.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int monthAmount) {
        return DateUtils.addInteger(date, 2, monthAmount);
    }

    public static java.util.Date addMonth(java.util.Date date, int monthAmount) {
        return DateUtils.addInteger(date, 2, monthAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtils.addInteger(date, 5, dayAmount);
    }

    public static java.util.Date addDay(java.util.Date date, int dayAmount) {
        return DateUtils.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtils.addInteger(date, 11, hourAmount);
    }

    public static java.util.Date addHour(java.util.Date date, int hourAmount) {
        return DateUtils.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int minuteAmount) {
        return DateUtils.addInteger(date, 12, minuteAmount);
    }

    public static java.util.Date addMinute(java.util.Date date, int minuteAmount) {
        return DateUtils.addInteger(date, 12, minuteAmount);
    }

    public static String addSecond(String date, int secondAmount) {
        return DateUtils.addInteger(date, 13, secondAmount);
    }

    public static java.util.Date addSecond(java.util.Date date, int secondAmount) {
        return DateUtils.addInteger(date, 13, secondAmount);
    }

    public static int getYear(String date) {
        return DateUtils.getYear(DateUtils.parseDate(date));
    }

    public static int getYear(java.util.Date date) {
        return DateUtils.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateUtils.getMonth(DateUtils.StringToDate(date));
    }

    public static int getMonth(java.util.Date date) {
        return DateUtils.getInteger(date, 2) + 1;
    }

    public static Long getMonthLastDay() {
        return DateUtils.getMonthLastDate().getTime();
    }

    public static java.util.Date getMonthLastDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat(DATE_FORMAT_YMD);
        cal.set(5, 1);
        cal.roll(5, -1);
        java.util.Date endTime = cal.getTime();
        String endTime1 = datef.format(endTime) + " 23:59:59";
        return DateUtils.StringToDate(endTime1, DATE_FORMAT_DEFAULT);
    }

    public static java.util.Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YMD);
        String lastDayOfMonth = sdf.format(cal.getTime()) + " 23:59:59";
        return DateUtils.StringToDate(lastDayOfMonth, DATE_FORMAT_DEFAULT);
    }

    public static java.util.Date getMonthFirstDate() {
        SimpleDateFormat datef = new SimpleDateFormat(DATE_FORMAT_YMD);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        java.util.Date startTime = c.getTime();
        String startTime1 = datef.format(startTime) + " 00:00:00";
        return DateUtils.StringToDate(startTime1, DATE_FORMAT_DEFAULT);
    }

    public static int getDay(String date) {
        return DateUtils.getDay(DateUtils.StringToDate(date));
    }

    public static int getDay(java.util.Date date) {
        return DateUtils.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateUtils.getHour(DateUtils.StringToDate(date));
    }

    public static int getHour(java.util.Date date) {
        return DateUtils.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateUtils.getMinute(DateUtils.StringToDate(date));
    }

    public static int getMinute(java.util.Date date) {
        return DateUtils.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateUtils.getSecond(DateUtils.StringToDate(date));
    }

    public static int getSecond(java.util.Date date) {
        return DateUtils.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtils.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(java.util.Date date) {
        return DateUtils.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateUtils.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(java.util.Date date) {
        return DateUtils.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        if (dateStyle != null) {
            java.util.Date myDate = DateUtils.StringToDate(date, dateStyle);
            week = DateUtils.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(java.util.Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static int getWeekByDate(java.util.Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static String getWeekStr(String date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_YMD);
        try {
            java.util.Date dt1 = df.parse(date);
            return weeks[Math.abs(DateUtils.getWeekByDate(dt1))];
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return "";
        }
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtils.getIntervalDays(DateUtils.StringToDate(date), DateUtils.StringToDate(otherDate));
    }

    public static int getIntervalDays(java.util.Date date, java.util.Date otherDate) {
        int num = -1;
        java.util.Date dateTmp = DateUtils.StringToDate(DateUtils.getDate(date), DateStyle.YYYY_MM_DD);
        java.util.Date otherDateTmp = DateUtils.StringToDate(DateUtils.getDate(otherDate), DateStyle.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = Math.abs(dateTmp.getTime() - otherDateTmp.getTime());
            num = (int)(time / 86400000L);
        }
        return num;
    }

    public static String date2Zodica(Calendar time) {
        return zodiacArr[time.get(1) % 12];
    }

    public static String getConstellation(int month, int day) {
        return day < constellationEdgeDay[month - 1] ? constellationArr[month - 1] : constellationArr[month];
    }

    public static int compare_date(String date) {
        return DateUtils.compare_date(new java.util.Date(), DateUtils.StringToDate(date, DATE_FORMAT_YMD));
    }

    public static int compare_date(java.util.Date d1, java.util.Date d2) {
        try {
            if (d1.getTime() > d2.getTime()) {
                System.out.println("dt1 \u5728dt2\u524d");
                return 1;
            }
            if (d1.getTime() < d2.getTime()) {
                System.out.println("dt1\u5728dt2\u540e");
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return 0;
        }
    }

    public static long compare_time(java.util.Date now, java.util.Date date) {
        if (now == null || date == null) {
            return 0L;
        }
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        return day;
    }

    public static long compare_time(long now, long t) {
        long l = now - t;
        long day = l / 86400000L;
        return day;
    }

    public static long compare_time2diff(java.util.Date sd, java.util.Date ed) {
        Long s = sd.getTime() / 1000L;
        Long e = ed.getTime() / 1000L;
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        return e - s;
    }

    public static float date2diff(java.util.Date sd, java.util.Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        Long diff = e - s;
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        return Float.valueOf(String.format("%s.%s", day, hour)).floatValue();
    }

    public static java.util.Date getYearFirstDay(int year) {
        String format = DATE_FORMAT_YMD;
        String firstDayDateString = year + "-01-01";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(firstDayDateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date getYearLastDay(int year) {
        String format = DATE_FORMAT_YMD;
        String lastDayDateString = year + "-12-31";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(lastDayDateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getAgeByDate(java.util.Date dateOfBirth) {
        int age = 0;
        Calendar born = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        if (dateOfBirth != null) {
            int bornDayOfYear;
            now.setTime(new java.util.Date());
            born.setTime(dateOfBirth);
            if (born.after(now)) {
                return 0;
            }
            age = now.get(1) - born.get(1);
            int nowDayOfYear = now.get(6);
            if (nowDayOfYear < (bornDayOfYear = born.get(6))) {
                --age;
            }
        }
        return age;
    }

    public static int getThisYear() {
        Calendar now = Calendar.getInstance();
        now.setTime(new java.util.Date());
        return now.get(1);
    }

    public static java.util.Date getDistanceDate(java.util.Date date, int type, int distance) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(type, distance);
        java.util.Date d = c.getTime();
        return d;
    }

    public static String formatCheckTime(java.util.Date beginTime, java.util.Date endTime, String splitor) {
        Object checkTime = "";
        String pattern = DATE_FORMAT_YMD;
        if (beginTime == null && endTime == null) {
            return checkTime;
        }
        if (beginTime == null) {
            return DateUtils.format(endTime, pattern);
        }
        if (endTime == null) {
            return DateUtils.format(beginTime, pattern);
        }
        checkTime = DateUtils.format(beginTime, pattern) + splitor + DateUtils.format(endTime, pattern);
        return checkTime;
    }

    public static String getThisYearLastTwo() {
        return new SimpleDateFormat("yy", Locale.CHINESE).format(Calendar.getInstance().getTime());
    }

    public static Boolean checkDateTimeFormat(String dateStr) {
        boolean isDateTime = false;
        if (dateStr != null && dateStr.length() > 0) {
            java.util.Date date = DateUtils.parseDate(dateStr);
            isDateTime = date != null;
        }
        return isDateTime;
    }

    public static boolean checkDate(String value) {
        boolean isDateTime = false;
        if (value != null && value.length() > 0) {
            java.util.Date date = null;
            try {
                date = DateUtils.parseDate((String)value, (String[])new String[]{"YYYY-m-d"});
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            isDateTime = date != null;
        }
        return isDateTime;
    }

    public static boolean checkDate2SQL(String value) {
        java.util.Date date = DateUtils.parseDate(value);
        try {
            int yyyy = DateUtils.getYear(date);
            int month = DateUtils.getMonth(date);
            int day = DateUtils.getDay(date);
            String tmp = String.format("%s-%s-%s", yyyy, month, day);
            Date.valueOf(tmp);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static String getRangeTime(java.util.Date beginTime, java.util.Date endTime, String splitor, String pattern) {
        if (beginTime != null && endTime != null) {
            return DateUtils.format(beginTime, pattern) + splitor + DateUtils.format(endTime, pattern);
        }
        if (beginTime != null) {
            return DateUtils.format(beginTime, pattern);
        }
        if (endTime != null) {
            return DateUtils.format(endTime, pattern);
        }
        return null;
    }

    public static java.util.Date getMonthLastDay(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static List<String> getLastSixMonth() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String dateString = sdf.format(cal.getTime());
        ArrayList<String> rqList = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            dateString = sdf.format(cal.getTime());
            rqList.add(dateString.substring(0, 7));
            cal.add(2, -1);
        }
        Collections.reverse(rqList);
        return rqList;
    }

    public static String getLastSixMonthStr() {
        List<String> times = DateUtils.getLastSixMonth();
        ArrayList<CallSite> months = new ArrayList<CallSite>();
        for (String time : times) {
            String[] timeA = time.split("-");
            months.add((CallSite)((Object)("'" + timeA[1] + "\u6708'")));
        }
        return String.join((CharSequence)",", months);
    }

    public static java.util.Date getByMonthRange(int monthRange) {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        cal.set(2, month - monthRange);
        return cal.getTime();
    }

    public static int differentDaysByDate(java.util.Date date1, java.util.Date date2) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YMD);
            java.util.Date day1 = sdf.parse(sdf.format(date1));
            java.util.Date day2 = sdf.parse(sdf.format(date2));
            int days = (int)Math.ceil((double)(day2.getTime() - day1.getTime()) / 8.64E7);
            return days;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return 0;
        }
    }

    public static java.util.Date initDateByDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static java.util.Date getDateByStr(String dateStr) {
        java.util.Date pointDate = null;
        if (StringUtil.isEmpty((String)dateStr)) {
            return pointDate;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DEFAULT);
        try {
            pointDate = format.parse(dateStr);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
        return pointDate;
    }

    public static String formatTime(Object timeTemp) {
        int timeParam = 0;
        if (timeTemp instanceof Integer) {
            timeParam = (Integer)timeTemp;
        }
        if (timeTemp instanceof String) {
            timeParam = Integer.parseInt((String)timeTemp);
        }
        int second = timeParam % 60;
        int minuteTemp = timeParam / 60;
        if (minuteTemp > 0) {
            int minute = minuteTemp % 60;
            int hour = minuteTemp / 60;
            if (hour > 0) {
                return (hour >= 10 ? "" + hour : "0" + hour) + ":" + (minute >= 10 ? "" + minute : "0" + minute) + ":" + (second >= 10 ? "" + second : "0" + second);
            }
            return "00:" + (minute >= 10 ? "" + minute : "0" + minute) + ":" + (second >= 10 ? "" + second : "0" + second);
        }
        return "00:00:" + (second >= 10 ? "" + second : "0" + second);
    }

    public static Boolean determineInThisWeek(java.util.Date dateToCheck) {
        if (null == dateToCheck) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        java.util.Date firstDayOfWeek = calendar.getTime();
        calendar.add(5, 6);
        java.util.Date lastDayOfWeek = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YMD);
        if (dateToCheck.after(firstDayOfWeek) && dateToCheck.before(lastDayOfWeek)) {
            return true;
        }
        return false;
    }

    public static java.util.Date getMondayDateInThisWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static java.util.Date getSundayDateInThisWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.add(5, 6);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }
}

