/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.model;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class LayuiGridData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long pages;
    private long page;
    private long total;
    private List<T> data;

    public LayuiGridData(Page<T> rows, LayuiGridParam param) {
        if (rows != null && param.getLimit() > 0) {
            this.pages = rows.getTotal() % (long)param.getLimit() == 0L ? rows.getTotal() / (long)param.getLimit() : (long)rows.getPages();
            this.page = param.getPage();
            this.total = rows.getTotal();
            this.data = rows;
        }
    }

    public LayuiGridData(PageInfo<T> rows, LayuiGridParam param) {
        if (rows != null && param.getLimit() > 0) {
            this.pages = rows.getTotal() % (long)param.getLimit() == 0L ? rows.getTotal() / (long)param.getLimit() : (long)rows.getPages();
            this.page = param.getPage();
            this.total = rows.getTotal();
            this.data = rows.getList();
        }
    }

    public LayuiGridData(PageInfo<T> rows) {
        if (rows != null && rows.getPageSize() > 0) {
            this.pages = rows.getTotal() % (long)rows.getPageSize() == 0L ? rows.getTotal() / (long)rows.getPageSize() : (long)rows.getPages();
            this.page = rows.getPageNum();
            this.total = rows.getTotal();
            this.data = rows.getList();
        }
    }

    public LayuiGridData(List<T> data) {
        if (data != null) {
            this.page = 1L;
            this.pages = 1L;
            this.total = data.size();
            this.data = data;
        }
    }

    public LayuiGridData(List<T> allList, Integer page, Integer size) {
        this.page = page.intValue();
        if (allList == null) {
            return;
        }
        this.pages = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.pages;
        }
        this.total = allList.size();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.data = l;
    }

    public LayuiGridData(List<T> allList, Integer page, Integer size, Integer total) {
        this.page = page.intValue();
        if (allList == null) {
            return;
        }
        this.pages = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.pages;
        }
        this.total = total.intValue();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.data = l;
    }

    public LayuiGridData(List<T> curList, Integer page, Integer size, Integer total, Integer pages) {
        if (curList == null) {
            return;
        }
        this.page = page.intValue();
        this.total = total.intValue();
        this.data = curList;
        this.pages = total / size;
        if (total % size != 0) {
            ++this.pages;
        }
    }

    @Generated
    public long getPages() {
        return this.pages;
    }

    @Generated
    public long getPage() {
        return this.page;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public List<T> getData() {
        return this.data;
    }

    @Generated
    public void setPages(long pages) {
        this.pages = pages;
    }

    @Generated
    public void setPage(long page) {
        this.page = page;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public void setData(List<T> data) {
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayuiGridData)) {
            return false;
        }
        LayuiGridData other = (LayuiGridData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LayuiGridData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LayuiGridData(pages=" + this.getPages() + ", page=" + this.getPage() + ", total=" + this.getTotal() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    @Generated
    public LayuiGridData() {
    }
}

