package cn.smarthse.radiationTraining.core.framework.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

/**
 * RSA加密解密
 * 整合springboot： https://gitee.com/ishuibo/rsa-encrypt-body-spring-boot
 * @author DELL2021
 */
@Slf4j
public class RsaUtil {

    /**
     * RSA：随机生成密钥对，返回map key：publicKey-公钥 privateKey-私钥
     *
     * @throws NoSuchAlgorithmException
     */
    public static Map<String, String> genKeyPair() {
        // KeyPairGenerator类用于生成公钥和私钥对，基于RSA算法生成对象
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        } catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException", e);
        }

        // 初始化密钥对生成器，密钥大小为96-2048位
        keyPairGen.initialize(512, new SecureRandom());

        // 生成一个密钥对，保存在keyPair中
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();   	// 得到私钥
        RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();  		// 得到公钥

        // 得到公钥字符串
        String publicKeyStr = new String(Base64.encodeBase64(publicKey.getEncoded()));
        // 得到私钥字符串
        String privateKeyStr = new String(Base64.encodeBase64((privateKey.getEncoded())));

        log.debug("随机生成的公钥为:" + publicKeyStr);
        log.debug("随机生成的私钥为:" + privateKeyStr);

        Map<String, String> result = new HashMap<>();
        result.put("publicKey", publicKeyStr);
        result.put("privateKey", privateKeyStr);

        return result;
    }

    public static String encrypt(String content, String publicKey) {

        byte[] data = content.getBytes();

        byte[] keyBytes = Base64.decodeBase64(publicKey);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicK);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;

            for(int i = 0; inputLen - offSet > 0; offSet = i * 117) {
                byte[] cache;
                if (inputLen - offSet > 117) {
                    cache = cipher.doFinal(data, offSet, 117);
                } else {
                    cache = cipher.doFinal(data, offSet, inputLen - offSet);
                }

                out.write(cache, 0, cache.length);
                ++i;
            }

            byte[] encryptedData = out.toByteArray();
            out.close();
            return new String(Base64.encodeBase64(encryptedData));
        } catch (Exception e) {
            log.error("Exception：", e);
            return null;
        }
    }

    public static String decrypt(String content, String privateKey) {

        byte[] text = Base64.decodeBase64(content);

        byte[] keyBytes = Base64.decodeBase64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);

        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateK);
            int inputLen = text.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;

            for(int i = 0; inputLen - offSet > 0; offSet = i * 256) {
                byte[] cache;
                if (inputLen - offSet > 256) {
                    cache = cipher.doFinal(text, offSet, 256);
                } else {
                    cache = cipher.doFinal(text, offSet, inputLen - offSet);
                }

                out.write(cache, 0, cache.length);
                ++i;
            }

            byte[] decryptedData = out.toByteArray();
            out.close();
            return new String(decryptedData);
        } catch (Exception e) {
            log.error("Exception:", e);
            return null;
        }
    }

//    public static void main(String[] args) {
//
//        //生成RSA公钥和私钥
//        //RsaUtil.genKeyPair();
//        String publicKey = "";
//        String privateKey = "";
//        String body = "123";
//
//        System.out.println("加密前：123");
//
//        //加密
//        String encode = RsaUtil.encrypt(body, publicKey);
//        System.out.println("加密后：" + encode);
//
//        //解密
//        String decrypt = RsaUtil.decrypt(encode, privateKey);
//        System.out.println("解密后：" + decrypt);
//    }
}
