//package cn.smarthse.radiationTraining.core.framework.utils;
//
//import java.io.BufferedInputStream;
//import java.io.IOException;
//import java.io.InputStream;
//import java.util.Arrays;
//import java.util.HashMap;
//import java.util.Map;
//
//import org.apache.poi.poifs.filesystem.FileMagic;
//import org.springframework.web.multipart.MultipartFile;
//
//public class FileValidationUtils {
//
//    private static final Map<String, String> MIME_TYPE_MAP = new HashMap<>();
//    public static final IllegalArgumentException INVALID_FILE_SIGNATURE = new IllegalArgumentException("Invalid file signature");
//
//    static {
//        MIME_TYPE_MAP.put("png", "image/png");
//        MIME_TYPE_MAP.put("jpeg", "image/jpeg");
//        MIME_TYPE_MAP.put("jpg", "image/jpeg");
//        MIME_TYPE_MAP.put("pdf", "application/pdf");
//        MIME_TYPE_MAP.put("doc", "application/msword");
//        MIME_TYPE_MAP.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
//        MIME_TYPE_MAP.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
//    }
//
//    public static void validateFile(MultipartFile file) {
//        String contentType = file.getContentType();
//        if (!MIME_TYPE_MAP.containsValue(contentType)) {
//            throw new IllegalArgumentException("Invalid content type");
//        }
//
//        String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
//        String expectedMimeType = MIME_TYPE_MAP.get(extension);
//        if (!expectedMimeType.equals(contentType)) {
//            throw new IllegalArgumentException("Mimetype does not match file extension");
//        }
//
//        FileMagic fileMagic;
//        try (InputStream is = new BufferedInputStream(file.getInputStream())) {
//            fileMagic = FileMagic.valueOf(is);
//        } catch (IOException e) {
//            throw new IllegalArgumentException("Invalid file");
//        }
//        switch (fileMagic) {
//            case OOXML:
//                if (!Arrays.asList("docx", "xlsx").contains(extension)) {
//                    throw INVALID_FILE_SIGNATURE;
//                }
//                break;
//            case OLE2:
//                if (!"doc".equals(extension)) {
//                    throw INVALID_FILE_SIGNATURE;
//                }
//                break;
//            case JPEG:
//                if (!Arrays.asList("jpg", "jpeg").contains(extension)) {
//                    throw INVALID_FILE_SIGNATURE;
//                }
//                break;
//            case PNG:
//                if (!"png".equals(extension)) {
//                    throw INVALID_FILE_SIGNATURE;
//                }
//                break;
//            case PDF:
//                if (!"pdf".equals(extension)) {
//                    throw INVALID_FILE_SIGNATURE;
//                }
//                break;
//            default:
//                throw new IllegalArgumentException("Unsupported file type");
//        }
//    }
//}