package cn.smarthse.radiationTraining.core.framework.utils;

import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;

/**
 * AES加密解密
 * <li>AES加密密码: 如果选择数据块128位，则要求密码长度为16,数据块192位则要求密码长度为24，数据块长度为256位，则要求密码长度为32</li>
 * 整合springboot： https://github.com/Licoy/encrypt-body-spring-boot-starter
 * @author DELL2021
 */
@Slf4j
public class AesUtil {

    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    private static final SysProperties sysProperties = SpringUtils.getBean(SysProperties.class);

    /**
     * AES加密
     * @param content 需要加密的内容
     * @param key aes密钥
     * @return {@link String}
     * @author liaoly
     * @date 2022/4/26 13:57
     */
    public static String encrypt(String content, String key) {
        try {
            byte[] raw = key.getBytes();  //获得密码的字节数组
            SecretKeySpec skey = new SecretKeySpec(raw, "AES"); //根据密码生成AES密钥
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);  //根据指定算法ALGORITHM自成密码器
            cipher.init(Cipher.ENCRYPT_MODE, skey); //初始化密码器，第一个参数为加密(ENCRYPT_MODE)或者解密(DECRYPT_MODE)操作，第二个参数为生成的AES密钥
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8); //获取加密内容的字节数组(设置为utf-8)不然内容中如果有中文和英文混合中文就会解密为乱码
            byte[] encodeContent = cipher.doFinal(byteContent); //密码器加密数据
            return Base64.encodeBase64String(encodeContent); //将加密后的数据转换为字符串返回
        } catch (Exception e) {
            log.error("Exception：", e);
            return null;
        }
    }

    /**
     * AES解密
     * @param encryptStr 加密后的内容
     * @param decryptKey aes密钥
     * @return {@link String}
     * @author liaoly
     * @date 2022/4/26 13:57
     */
    public static String decrypt(String encryptStr, String decryptKey) {
        try {
            byte[] raw = decryptKey.getBytes();  //获得密码的字节数组
            SecretKeySpec skey = new SecretKeySpec(raw, "AES"); //根据密码生成AES密钥
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);  //根据指定算法ALGORITHM自成密码器
            cipher.init(Cipher.DECRYPT_MODE, skey); //初始化密码器，第一个参数为加密(ENCRYPT_MODE)或者解密(DECRYPT_MODE)操作，第二个参数为生成的AES密钥
            byte[] encodeContent = Base64.decodeBase64(encryptStr); //把密文字符串转回密文字节数组
            byte[] byteContent = cipher.doFinal(encodeContent); //密码器解密数据
            return new String(byteContent, StandardCharsets.UTF_8); //将解密后的数据转换为字符串返回
        } catch (Exception e) {
            log.error("Exception：", e);
            return null;
        }
    }

    /**
     * AES加密（默认aes密钥）
     * @param content 需要加密的内容
     * @return {@link String}
     * @author liaoly
     * @date 2022/4/26 13:57
     */
    public static String encrypt(String content) {
        try {
            byte[] raw = sysProperties.getAesKey().getBytes();  //获得密码的字节数组
            SecretKeySpec skey = new SecretKeySpec(raw, "AES"); //根据密码生成AES密钥
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);  //根据指定算法ALGORITHM自成密码器
            cipher.init(Cipher.ENCRYPT_MODE, skey); //初始化密码器，第一个参数为加密(ENCRYPT_MODE)或者解密(DECRYPT_MODE)操作，第二个参数为生成的AES密钥
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8); //获取加密内容的字节数组(设置为utf-8)不然内容中如果有中文和英文混合中文就会解密为乱码
            byte[] encodeContent = cipher.doFinal(byteContent); //密码器加密数据
            return Base64.encodeBase64String(encodeContent); //将加密后的数据转换为字符串返回
        } catch (Exception e) {
            log.error("Exception：", e);
            return null;
        }
    }

    /**
     * AES解密（默认aes密钥）
     * @param encryptStr 加密后的内容
     * @return {@link String}
     * @author liaoly
     * @date 2022/4/26 13:57
     */
    public static String decrypt(String encryptStr) {
        try {
            byte[] raw = sysProperties.getAesKey().getBytes();  //获得密码的字节数组
            SecretKeySpec skey = new SecretKeySpec(raw, "AES"); //根据密码生成AES密钥
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);  //根据指定算法ALGORITHM自成密码器
            cipher.init(Cipher.DECRYPT_MODE, skey); //初始化密码器，第一个参数为加密(ENCRYPT_MODE)或者解密(DECRYPT_MODE)操作，第二个参数为生成的AES密钥
            byte[] encodeContent = Base64.decodeBase64(encryptStr); //把密文字符串转回密文字节数组
            byte[] byteContent = cipher.doFinal(encodeContent); //密码器解密数据
            return new String(byteContent, StandardCharsets.UTF_8); //将解密后的数据转换为字符串返回
        } catch (Exception e) {
            log.error("Exception：", e);
            return null;
        }
    }
}
