package cn.smarthse.radiationTraining.core.framework.mybatis.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 修改记录对象
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/4/9 15:58
 */
@EqualsAndHashCode(callSuper = false)
@TableName(value = "sys_change_log")
@Data
public class SysChangeLog extends BaseBean implements Serializable {

    @Serial
    private static final long serialVersionUID = -1L;

    @TableId
    private Long id;

    //@ApiModelProperty("操作批次编码（用于标记那些字段是一起编辑的）")
    private Long batchCode;

    //@ApiModelProperty("表名")
    private String tableName;

    //@ApiModelProperty("记录ID")
    private Long dataId;

    //@ApiModelProperty("字段名（及时完善SysChangeLogEnum）")
    private String fieldName;

    //@ApiModelProperty("字段名en")
    private String fieldValue;

    //@ApiModelProperty("旧值")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String beforeValue;

    //@ApiModelProperty("新值")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String afterValue;

    //@ApiModelProperty("操作账号所在组织ID")
    private Long cid;

    //@ApiModelProperty("操作账号ID")
    private Long userId;

    //@ApiModelProperty("操作账号名称")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    //@ApiModelProperty("操作类型（insert、update、delete）")
    private String operation;

    //@ApiModelProperty("操作时间")
    private LocalDateTime editTime;

    //@ApiModelProperty("修改内容")
    private String content;

    //==================================================================

    //@ApiModelProperty("比如：院区名称")
    @TableField(exist = false)
    private String dataName;

}
