package cn.smarthse.radiationTraining.core.framework.mybatis;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysChangeLogEnum {

    // ra_tu_certificate
    ra_tu_cert_uname(1001, "ra_tu_certificate", "uname", "姓名变更"),
    ra_tu_cert_id_card(1002, "ra_tu_certificate", "id_card", "身份证号变更"),
    ra_tu_cert_sex(1003, "ra_tu_certificate", "sex", "性别变更"),
    ra_tu_cert_unit_name(1004, "ra_tu_certificate", "unit_name", "所在单位名称变更"),
    ra_tu_cert_unit_credit_code(1005, "ra_tu_certificate", "unit_credit_code", "所在单位统一社会信用代码变更"),
    ra_tu_cert_cert_type(1006, "ra_tu_certificate", "cert_type", "证书类型变更"),
    ra_tu_cert_issue_time(1007, "ra_tu_certificate", "issue_time", "证书发证日期变更"),
    ra_tu_cert_invalid_date(1008, "ra_tu_certificate", "invalid_date", "证书有效日期变更"),
    ra_tu_cert_training_result(1009, "ra_tu_certificate", "training_result", "培训结果变更"),
    ra_tu_cert_certificate_no(1010, "ra_tu_certificate", "certificate_no", "证书编号变更"),
    ra_tu_cert_training_unit_name (1011, "ra_tu_certificate", "training_unit_name", "发证单位变更"),

    ;

    private final Integer key;
    private final String tableName;
    private final String column;
    private final String value;

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (SysChangeLogEnum remind : SysChangeLogEnum.values()) {
            if (Objects.equals(key, remind.getKey())) {
                return remind.getValue();
            }
        }
        return null;
    }

    public static SysChangeLogEnum[] getByTableName(String tableName) {

        return Arrays.stream(SysChangeLogEnum.values())
                .filter(c -> tableName.equals(c.getTableName()))
                .toArray(SysChangeLogEnum[]::new);
    }
    public static String getValueByTableAndField(String tableName, String column) {
        if (tableName == null || column == null) {
            return null;
        }
        for (SysChangeLogEnum item : SysChangeLogEnum.values()) {
            if (item.getTableName().equals(tableName) && item.getColumn().equals(column)) {
                return item.getValue();
            }
        }
        return null;
    }

}
