package cn.smarthse.radiationTraining.core.framework.model;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 基础查询参数对象
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class PageParam extends LayuiGridParam {

    /**
     * 关键字
     */
    private String keyword;
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String keywordEn;

    /**
     * 查询开始日期
     */
    private Date beginDate;

    /**
     * 查询结束日期
     */
    private Date endDate;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 行政区划id
     */
    private Long areaId;

    /**
     * 行政区划level
     */
    private Integer level;

    /**
     * 行政区划id集合
     */
    private List<Long> areaIdList;

    public Integer getLevel() {
        return StringUtils.getAreaLevel(this.areaId);
    }

}
