package cn.smarthse.radiationTraining.core.framework.model;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * 1.按照layui的格式定义一个 分页bean
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月23日 下午4:21:18
 */
@Data
@NoArgsConstructor
public class LayuiGridData<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	/** 总页数 */
	//@ApiModelProperty("总页数")
	private long pages;
	/** 页码 */
	//@ApiModelProperty("页码")
	private long page;
	/** 总数 */
	//@ApiModelProperty("总数")
	private long total;
	/** 数据实体 */
	//@ApiModelProperty("数据实体")
	private List<T> data;

	public LayuiGridData(Page<T> rows, LayuiGridParam param) {
		if (rows != null && param.getLimit() > 0) {
			if (rows.getTotal() % param.getLimit() == 0) {
				this.pages = rows.getTotal() / param.getLimit();
			} else {
				this.pages = rows.getPages(); //总页数
			}
			this.page = param.getPage(); //页码
			this.total = rows.getTotal(); //总数
			this.data = rows;
		}
	}

	public LayuiGridData(PageInfo<T> rows, LayuiGridParam param) {
		if (rows != null && param.getLimit() > 0) {
			if (rows.getTotal() % param.getLimit() == 0) {
				this.pages = rows.getTotal() / param.getLimit();
			} else {
				this.pages = rows.getPages(); //总页数
			}
			this.page = param.getPage(); //页码
			this.total = rows.getTotal(); //总数
			this.data = rows.getList();
		}
	}

	public LayuiGridData(PageInfo<T> rows) {
		if (rows != null && rows.getPageSize() > 0) {
			if (rows.getTotal() % rows.getPageSize() == 0) {
				this.pages = rows.getTotal() / rows.getPageSize();
			} else {
				this.pages = rows.getPages(); //总页数
			}
			this.page = rows.getPageNum(); //页码
			this.total = rows.getTotal(); //总数
			this.data = rows.getList();
		}
	}

	/**
	 * 不分页
	 * @param data
	 */
	public LayuiGridData(List<T> data) {
		if (data != null) {
			this.page = 1;
			this.pages = 1;
			this.total = data.size();
			this.data = data;
		}
	}

	/**
	 * 分页
	 */
	public LayuiGridData(List<T> allList, Integer page, Integer size) {

			this.page = page;
			if(allList == null){
				return;
			}
			this.pages = allList.size() / size;
			if(allList.size() % size != 0){
				this.pages += 1;
			}
			this.total = allList.size();
			List<T> l = new LinkedList<>();
			for(int i = (page - 1) * size; i < page * size && i < allList.size(); i++) {
				l.add(allList.get(i));
			}
			this.data = l;
	}

	/**
	 * 分页
	 */
	public LayuiGridData(List<T> allList, Integer page, Integer size, Integer total) {

		this.page = page;
		if(allList == null){
			return;
		}
		this.pages = allList.size() / size;
		if(allList.size() % size != 0){
			this.pages += 1;
		}
		this.total = total;
		List<T> l = new LinkedList<>();
		for(int i = (page - 1) * size; i < page * size && i < allList.size(); i++) {
			l.add(allList.get(i));
		}
		this.data = l;
	}

	/**
	 * 假分页
	 * @param curList 已经分页后的数据
	 */
	public LayuiGridData(List<T> curList, Integer page, Integer size, Integer total,Integer pages) {

		if(curList == null){
			return;
		}
		this.page = page;
		this.total = total;
		this.data = curList;
		this.pages = total / size;
		if(total % size != 0){
			this.pages += 1;
		}
	}



}
