package cn.smarthse.radiationTraining.core.framework.filter.dubbo;

import cn.hutool.core.convert.Convert;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import lombok.Data;
import org.apache.dubbo.rpc.RpcContext;

import java.io.Serializable;

@Data
public class RtsUserInfoHolder implements Serializable {

    public static final String userid = "rts-userId";
    public static final String username = "rts-userName";

    private Long userId;

    private String userName;

    public static RtsUserInfoHolder getCurrentUser() {
        RtsUserInfoHolder userInfo = new RtsUserInfoHolder();
        try {
            RpcContext rpcContext = RpcContext.getServiceContext();
            String userIdStr = rpcContext.getAttachment(userid);
            String userName = rpcContext.getAttachment(username);

            userInfo.setUserId(Convert.toLong(userIdStr));
            userInfo.setUserName(userName);
        } catch (Exception ignored) {

        }

        if (userInfo.getUserId() == null) {
            try {
                userInfo.setUserId(JwtUtil.getUserId(JwtUtil.getToken()));
            } catch (IllegalStateException e) {
                // 在非Web环境中无法获取token，忽略该异常
            }
        }
        if (userInfo.getUserName() == null) {
            try {
                userInfo.setUserName(JwtUtil.getUsername(JwtUtil.getToken()));
            } catch (IllegalStateException e) {
                // 在非Web环境中无法获取token，忽略该异常
            }
        }

        return userInfo;
    }

}