package cn.smarthse.radiationTraining.core.framework.filter.dubbo;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.*;
import org.slf4j.MDC;

/**
 *
 * dubbo调用生产者拦截，获取消费者传过来的全局日志链路标记"trackId"， 并添加 全局日志链路标记
 * 1. dubbo.provider.filter: ProviderMdcFilter
 * 2. META-INF/dubbo/org.apache.dubbo.rpc.Filter 文件内容：ProviderMdcFilter=cn.smarthse.radiationTraining.modules.sys.bootstrap.filter.ConsumerMdcFilter
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/10 17:16
 */
@Slf4j
public class ProviderMdcFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        MDC.put("trackId", invocation.getAttachment("trackId"));
        MDC.put(Constant.TOKEN_HEADER_NAME, invocation.getAttachment(Constant.TOKEN_HEADER_NAME));
        try {
            return invoker.invoke(invocation);
        } finally {
            MDC.clear();
        }
    }
}

