package cn.smarthse.radiationTraining.core.framework.filter.dubbo;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.*;
import org.slf4j.MDC;

/**
 *
 * dubbo调用消费者拦截，添加 全局日志链路标记
 * 1. dubbo.consumer.filter: ConsumerMdcFilter
 * 2. META-INF/dubbo/org.apache.dubbo.rpc.Filter 文件内容：ProviderMdcFilter=cn.smarthse.radiationTraining.modules.wx.bootstrap.filter.ConsumerMdcFilter
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/10 17:16
 */
@Slf4j
public class ConsumerMdcFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        invocation.setAttachment("trackId", MDC.get("trackId"));
        //invocation.setAttachment(Constant.TOKEN_HEADER_NAME, MDC.get(Constant.TOKEN_HEADER_NAME));
        invocation.setAttachment(Constant.TOKEN_HEADER_NAME, JwtUtil.getToken());

        return invoker.invoke(invocation);
    }
}

