package cn.smarthse.radiationTraining.core.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 系统配置文件
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/12/6 14:12
 */
@ConfigurationProperties(prefix = "sys")
public @Data class SysProperties {

    /**
     * 大数据日志appcode
     */
    private String bigDataLogAppCode;

    /**
     * 监管单点登录 签名key
     * AES密钥
     */
    public String aesKey;

    /**
     * 报名二维码AES密钥
     */
    public String enrollQrcodeAesKey;

    /**
     * 网站地址
     */
    public String webUrl;

    /**
     * 证书背景相对地址
     */
    private String certBgImg;

    /**
     * 证书预览地址QR
     */
    private String certQrUrl;

    /**
     * 证书oss链接有效期（默认3600 * 24 * 3 秒）
     */
    private int certUrlExp = 3600 * 24 * 3;

    /**
     * 定时任务是否开启，默认关闭 false
     */
    private boolean task = false;

    /**
     * 特殊账号名称
     */
    private String specifiedUser;

    /**
     * 培训版本号
     */
    private String trainingVersion;

    /**
     * 文件上传支持的文件类型
     */
    private List<String> supportFileTypes = Arrays.asList(new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf", "jpg", "jpeg", "png", "txt", "wmv", "mp4", "m4v"});
    private List<String> supportM3U8FileTypes = Arrays.asList(new String[]{"mp4", "m4v"});

    /**
     * 表字段级修改记录配置
     */
    @NestedConfigurationProperty
    private DataChangeRecorder dataChangeRecorder = new DataChangeRecorder();

    /**
     * 表字段级修改记录配置
     */
    @Data
    public static class DataChangeRecorder {

        boolean enable = false;

        /**
         * 记录修改记录字段配置 key：表名，value：字段（key: 字段名; value: 中文含义）<br/>
         * eg: <code>b_company: {name: 单位名称, credit_code: 统一社会信用代码, area_id: 行政区划}</code>
         */
        Map<String, Map<String, String>> tableColumnMap;

        /**
         * 逻辑删除字段，更新该字段需要标记为删除
         */
        String delColumn = "is_valid";
    }
}