package cn.smarthse.radiationTraining.core.framework.bootstrap;


import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import jakarta.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 *
 * 设置编辑信息参数 aop order越小越先执行
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/12 15:40
 */
@Aspect
@Component
@Slf4j
@Order(2)
public class EditParamAopAspect {

	/**
	 * 切入点
	 */
	@Pointcut("execution(public * cn.smarthse.radiationTraining..*.controller..*.*(..))")
	public void pointCut() {
	}

	/**
	 * 前置操作
	 * @param point 切入点
	 */
	@Before("pointCut()")
	public void beforeLog(JoinPoint point) {

		//设置操作账号信息
		initUserEditParam(point.getArgs(), ServletUtils.getRequest());
	}

	/**
	 * 设置操作账号信息
	 * @author liaoly
	 * @date 2022/3/15 10:44
	 * @param args 参数集
	 * @param request 请求
	 */
	private void initUserEditParam(Object[] args, HttpServletRequest request) {
		if (args == null) {
			return;
		}

		for (Object arg : args) {
			//UserEditParam 是标准的编辑操作信息
			if (arg instanceof UserEditParam) {
				String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
				if (token != null && !token.isEmpty()) {
					((UserEditParam) arg).setLoginUserId(JwtUtil.getUserId(token));
					((UserEditParam) arg).setLoginName(JwtUtil.getName(token));
					((UserEditParam) arg).setLoginUsername(JwtUtil.getUsername(token));
				}
			}
		}
	}
}

