package cn.smarthse.radiationTraining.core.framework.annotation;

/**
 *
 *  日志来源
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4年9:27月日
 */
public enum LogResourceEnum {

	/**
	 * 首页-1
	 */
	ADMIN("admin", 1, "后台"),
	/**
	 * PC客户端-2
	 */
	WWW("www", 2, "PC客户端"),
	/**
	 * 移动端-3
	 */
	WX("wx", 3, "移动端"),

	anon("-", 0, "其他"),
	;

	/**
	 * 日志来源
	 */
	public String name;
	/**
	 * 日志来源编码
	 */
	public String code;
	/**
	 * 日志来源编码
	 */
	public Integer value;
	// 构造方法

	LogResourceEnum(String code, Integer value, String name) {
		this.code = code;
		this.value = value;
		this.name = name;
	}

	public static LogResourceEnum getByValue(Integer value) {
		for (LogResourceEnum c : LogResourceEnum.values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return LogResourceEnum.anon;
	}
	
	public static String getLogResourceName(Integer value) {
		
		return getByValue(value).getName();
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}

	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}
