package cn.smarthse.radiationTraining.core.framework.annotation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 *  日志模块分类
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4年9:27月日
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LogModuleTypeEnum {
	// todo 待完善
	/**
	 * 放射卫生培训管理-2
	 */
	training("training", 2, "培训管理"),
	/**
	 * 课程组管理-3
	 */
	class_group("class_group", 3, "课程组管理"),
	/**
	 * 试题管理-4
	 */
	question("question", 4, "试题管理"),
	/**
	 * 订单-5
	 */
	order("order", 5, "订单管理"),
	/**
	 * 系统管理-6
	 */
	sys("sys", 6, "系统管理"),
	/**
	 * 课程管理-8
	 */
	class_course("class_course", 8, "课程管理"),
	/**
	 * 用户报名管理_单位端
	 */
	user_enroll_crop("user_enroll_crop", 9, "用户报名管理_单位端"),
	/**
	 * 单位报名管理_单位端
	 */
	unit_enroll_crop("user_enroll_crop", 10, "单位报名管理_单位端"),
	/**
	 * 用户报名管理_监管端
	 */
	user_enroll_admin("user_enroll_admin", 11, "用户报名管理_监管端"),
	/**
	 * 单位报名管理_监管端
	 */
	unit_enroll_admin("unit_enroll_admin", 12, "单位报名管理_监管端"),
	user_enroll_person("unit_enroll_person", 13, "用户报名管理_个人端"),

	user_info_wx("user",14,"个人端_用户信息"),
	order_user_info_admin("order_user",15,"监管端_订单用户信息"),

	anon("-", 0, "其他"),
	;
	// 成员变量
	/**
	 * 模块名
	 */
	public String moduleName;
	/**
	 * 模块编码
	 */
	public String moduleCode;
	/**
	 * 模块编码
	 */
	public Integer moduleType;
	// 构造方法
	
	private LogModuleTypeEnum(String moduleCode, Integer moduleType, String moduleName) {
		this.moduleName = moduleName;
		this.moduleType = moduleType;
		this.moduleCode = moduleCode;
	}

	public static LogModuleTypeEnum getByModuleType(Integer moduleType) {
		for (LogModuleTypeEnum c : LogModuleTypeEnum.values()) {
			if (c.getModuleType().equals(moduleType)) {
				return c;
			}
		}
		return LogModuleTypeEnum.anon;
	}
	
	public static String getModuleNameByModuleType(Integer moduleType) {
		
		return getByModuleType(moduleType).getModuleName();
	}

}
