package cn.smarthse.radiationTraining.core.framework;

import cn.hutool.crypto.digest.MD5;

import javax.smarthse.framework.exception.ServiceException;

/**
 * @author lixiao
 * @date 2019/10/26 12:03
 */
public class RedisKey {

	/**
	 * 分布式锁key
	 */
	public static String LOCK_KEY = "LOCK";
	/**
	 * 文章点击量key
	 */
	public static String ARTICLE_CLICK_KEY = "ARTICLE:CLICK:ZSET";

	/**
	 * 分布式锁key
	 * @param key 唯一标记
	 */
	public static String getLockKey(String key) {
		return "LOCK:" + key;
	}

	/**
	 * 注册验证码
	 */
	public static String getRegisterCodeKey(String email) {
		return "REGISTER:CODE:" + email;
	}

	/**
	 * 登录验证码
	 */
	public static String getLoginCodeKey(String phone) {
		return "LOGIN:CODE:" + phone;
	}

	/**
	 * 修改密码验证码
	 */
	public static String getModifyPasswordCodeKey(String phone) {
		return "MODIFY:PWD:CODE:" + phone;
	}

	/**
	 * 验证码
	 */
	public static String getVCodeKey(String key) {
		return "VCODE:" + key;
	}

	/**
	 * 邮箱验证码
	 */
	public static String getEmailCodeKey(String key) {
		return "EMAIL:CODE:" + key;
	}
	public static String getPhoneCodeKey(String key) {
		return "PHONE:CODE:" + key;
	}

	public static String getPhoneRegisterCodeKey(String key) {
		return "PHONE:CODE:REGISTER" + key;
	}

	public static String getPhoneMdCodeKey(String key) {
		return "PHONE:CODE:md" + key;
	}

	/**
	 * 登录principal缓存key
	 */
	public static String getLoginUserKey(String username) {
		return "LOGIN:USER:" + username;
	}

	/**
	 * 登录principal缓存key
	 */
	public static String getLoginUserKey(Long userId) {
		return "LOGIN:USER:" + userId;
	}

	/**
	 * 登录wx principal缓存key
	 */
	public static String getWXLoginUserKey(Long userId) {
		return "LOGIN:WX:" + userId;
	}

	/**
	 * 登录admin principal缓存key
	 */
	public static String getAdminLoginUserKey(Long userId) {
		return "LOGIN:ADMIN:" + userId;
	}

	/**
	 * 请求限制key
	 */
	public static String getRequestLimitKey(String ip, String servletPath, String param) {
		return "LIMIT:" + MD5.create().digestHex(ip + servletPath + param);
	}

	/**
	 * admin的token验签密钥 的缓存key
	 */
	public static String getAdminTokenSecret(Long userId) {
		return "TOKEN:ADMIN:SECRET:" + userId;
	}

	/**
	 * token验签密钥 的缓存key
	 */
	public static String getTokenSecret(Long userId) {
		return "TOKEN:USER:SECRET:" + userId;
	}

	/**
	 * 请求百度api的userId队列 的缓存key
	 */
	public static String getRequestQueueFaceMatch() {

		return "REQUEST:QUEUE:faceMatch";
	}

	/**
	 * 课程缓存key
	 * @param itemId 课程id
	 * @return {@link String}
	 * @author chenliang
	 * @date 2022/12/8 9:17
	 */

	public static String getCourseItemVo(Long itemId) {

		return itemId == null ?  "COURSE:ITEM" : "COURSE:ITEM:" + itemId;
	}

	/**
	 * @Description 培训缓存key
	 * @Date 2022/6/22
	 * @param tid 培训id
	 * @Author chuhy
	 **/
	public static String getTrainingVo(Long tid) {

		return tid == null ?  "TRAINING" : "TRAINING:" + tid;
	}

	/**
	 * @Description 培训info缓存key
	 * @Date 2022/6/22
	 * @param tid 培训id
	 * @Author chuhy
	 **/
	public static String getTrainInfoVo(Long tid) {

		return tid == null ?  "TRAINING:INFO" : "TRAINING:INFO::" + tid;
	}

	/**
	 * @Description 培训-工作类别缓存key
	 * @Date 2022/6/22
	 * @param code 工作类别
	 * @Author chuhy
	 **/
	public static String getTrainWorkType(String code) {

		return code == null ?  "TRAINING:WORKTYPE" : "TRAINING:WORKTYPE:" + code;
	}

	/**
	 * @Description 个人试卷(TuPaper)缓存key
	 * @Date 2022/6/24
	 * @param tuPaperId 个人试卷id
	 * @Author chuhy
	 **/
	public static String getTuPaper(Long tuPaperId) {

		return tuPaperId == null ?  "TUPAPER" : "TUPAPER:" + tuPaperId;
	}

	/**
	 * @Description 个人试卷-试题(TuPaperQuestion)缓存key
	 * @Date 2022/6/24
	 * @param tuPaperId 个人试卷id
	 * @Author chuhy
	 **/
	public static String getTuPaperQuestion(Long tuPaperId) {

		return tuPaperId == null ?  "TUPAPERQUESTION" : "TUPAPERQUESTION:" + tuPaperId;
	}


	/**
	 * @Author chenliang
	 * @Description 部分用户记录
	 * @Date 18:10 2022/6/22
	 * @Param [tuCourseId]
	 * @return java.lang.String
	**/
	public static String getTuCourse(Long tuCoruseId) {

		return tuCoruseId == null ?  "TUCOURSE:CACHE" : "TUCOURSE:CACHE:" + tuCoruseId;
	}

	/**
	 * @Author chenliang
	 * @Description 获取tuCourseId
	 * @Date 18:10 2022/6/22
	 * @Param [tuCourseId]
	 * @return java.lang.String
	 **/
	public static String getTuCourseId(Long detailId, Long courseItemId) {
		if((detailId == null && courseItemId != null) || (detailId != null && courseItemId == null)){throw new ServiceException("学习记录id缓存结构key错误"); }
		return detailId == null || courseItemId == null ?  "TUCOURSE:ID" : new StringBuffer("TUCOURSE:ID:").append(detailId).append("s").append(courseItemId).toString();
	}

	/**
	 * @Author chenliang
	 * @Description TODO
	 * @Date 18:11 2022/6/22
	 * @Param [trainCourseId]
	 * @return java.lang.String
	**/
	public static String getTrainCourse(Long trainCourseId) {

		return trainCourseId == null ?  "TRAIN:COURSE" : "TRAIN:COURSE:" + trainCourseId;
	}


	/**
	 * @Author chenliang
	 * @Description 培训目录基础信息
	 * @Date 18:11 2022/6/22
	 * @Param [trainCourseId]
	 * @return java.lang.String
	 **/
	public static String getCatalogue(Long tid) {
		return tid == null ?  "TRAIN:CATALOGUE" : "TRAIN:CATALOGUE:" + tid;
	}

	/**
	 * @Author chenliang
	 * @Description 单位报名防重复操作key
	 * @Date 18:11 2022/6/22
	 * @Param targetId:公司报名用cid，用户报名用uid
	 * @return java.lang.String
	 **/
	public static String getAtomEnrollOpt(Long tid,Long targetId) {
		return tid == null ?  "ATOM:OPT:ENROLL" :new StringBuffer( "ATOM:OPT:ENROLL:").append(tid).append("s").append(targetId).toString();
	}

	/**
	 * @Author chenliang
	 * @Description 单位报名防重复操作key
	 * @Date 18:11 2022/6/22
	 * @Param targetId:公司报名用cid，用户报名用uid
	 * @return java.lang.String
	 **/
	public static String getEnrollQRCode(Long tid, Long cid) {
		return tid == null ?  "ENROLL:QCRCODE:EXPIRATION:TIME" :new StringBuffer( "ENROLL:QCRCODE:EXPIRATION:TIME:").append(tid).append("s").append(cid).toString();
	}
	/**
	 * @Author chenliang
	 * @Description 操作指南key
	 * @return java.lang.String
	 **/
	public static String getInstructions() {
		return "WEB:INSTRUCTIONS";
	}
	/**
	 * 单位更新时间
	 * @return {@link Object}
	 * @author chenliang
	 * @date 2023/2/21 16:48
	 */
	public static String getUpUnitTimeKey() {
		return "SYNC:UNIT:UPDATE:TIME";
	}
	/**
	 * 服务机构
	 * @return {@link Object}
	 * @author chenliang
	 * @date 2023/2/21 16:48
	 */
	public static String getUpOrgTimeKey() {
		return "SYNC:ORG:UPDATE:TIME";
	}
}
