package cn.smarthse.radiationTraining.core.framework;

import java.util.concurrent.TimeUnit;

/**
 * 常量类
 * @author liaoly
 * @date 2022/2/11 22:56
 */
public class Constant {

	/**
	 * 验证码过期时间 此处为五分钟
	 */
	public static Integer CODE_EXPIRE_TIME = 60;

	/**
	 * 手机验证码过期时间
	 */
	public static Integer PHONE_EXPIRE_TIME = 5;
	public static Integer CODE_EXPIRE_TIME_2 = 5;

	/**
	 * jwtToken过期时间 20天
	 */
//	public static Long TOKEN_EXPIRE_TIME = TimeUnit.MINUTES.toMillis(1);//测试人员测试用
	public static Long TOKEN_EXPIRE_TIME = TimeUnit.DAYS.toMillis(20);
	public static Long WX_TOKEN_EXPIRE_TIME = TimeUnit.HOURS.toMillis(12);

	/**
	 * jwtToken刷新时间 30天
	 */
//	public static Long TOKEN_REFRESH_TIME = TimeUnit.MINUTES.toMillis(2);//测试人员测试用
	public static Long TOKEN_REFRESH_TIME = TimeUnit.DAYS.toMillis(30);

	public static Long WX_TOKEN_REFRESH_TIME = TimeUnit.HOURS.toMillis(15);

	/**
	 * jwtToken验签secret过期时间 21天（比jwtToken过期时间长些）
	 */
	public static Integer TOKEN_SECRET_EXPIRE_TIME = 30;
	/**
	 * jwtToken验签secret过期时间 15小时（比jwtToken过期时间长些）
	 */
	public static Integer WX_TOKEN_SECRET_EXPIRE_TIME = 15;

	/**
	 * redis中的 principal 对象的缓存有效时长30分钟
	 */
	public static Long REDIS_PRINCIPAL_TIME = TimeUnit.MINUTES.toMinutes(30);

	/**
	 * token请求头名称
	 */
	public static String TOKEN_HEADER_NAME = "token";
	
	/**
	 * token请求头名称
	 */
	public static String REFRESH_TOKEN_NAME = "refreshToken";

	public static Boolean TRUE = true;

	public static Boolean FALSE = false;

	public static int YES = 1;

	public static int NO = 0;

	/**
	 * 权限编码后缀-查看权限
	 */
	public static final String permission_view_suffix = ":view";
	/**
	 * 权限编码后缀-编辑权限
	 */
	public static final String permission_edit_suffix = ":edit";

	/** 验证码- 默认长度 */
	public static final int DEFAULT_LEN = 4;
	/** 验证码- 默认宽度 */
	public static final int DEFAULT_WIDTH = 130;
	/** 验证码- 默认高度 */
	public static final int DEFAULT_HEIGHT = 48;

	/** 文件上传的文件名称 最大长度 */
	public static final int MAX_FILE_NAME_LENGTH = 128;
	/** 默认密码 */
	public static final String DEFAULT_PASSWORD = "Zyj@2022";
	public static final String DEFAULT_SUPERVISE_PASSWORD = "Zjs@2022";

	/**
	 * 订单失效时间 30分钟
	 */
	public static final int ORDER_EXPIRE_TIME = 30;
	/**
	 * 订单失效时间表达式 10m
	 */
	public static final String ORDER_EXPIRE_TIME_EXPRESS = ORDER_EXPIRE_TIME + "m";

}
