/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.utils;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private static String audience;

    @Value(value="${jwt.audience}")
    public void setAudience(String audience) {
        JwtUtil.audience = audience;
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String getName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("name").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String getIP(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("ip").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter("refreshToken");
        }
        return token;
    }

    public static String createToken(String username, Long userId, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withClaim("userId", userId).withAudience(new String[]{audience}).withExpiresAt(date).sign(algorithm);
    }

    public static String createToken(String username, Long userId, String name, String ip, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withClaim("userId", userId).withClaim("name", name).withClaim("ip", ip).withAudience(new String[]{audience}).withExpiresAt(date).sign(algorithm);
    }

    public static boolean verify(String token, String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).withAudience(new String[]{audience}).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    public static boolean verify(String token, String secret, String currentIp) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).withClaim("ip", JwtUtil.getIP(token)).withAudience(new String[]{audience}).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    public static boolean verifyIp(String token, String remoteAddr) {
        String ip = JwtUtil.getIP(token);
        if (StringUtils.isBlank((CharSequence)remoteAddr) || StringUtils.isBlank((CharSequence)ip)) {
            return true;
        }
        return remoteAddr.equalsIgnoreCase(ip);
    }

    public static Boolean isTokenExpired(String token) {
        Date expiration = JwtUtil.getExpirationDateFromToken(token);
        return expiration == null || expiration.before(new Date());
    }

    private static Date getExpirationDateFromToken(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asDate();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }
}

