/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.utils;

import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.SpringContextHolder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AesUtil.class);
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";
    private static final SysProperties sysProperties = SpringContextHolder.getBean(SysProperties.class);

    public static String encrypt(String content, String key) {
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec skey = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(1, skey);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            byte[] encodeContent = cipher.doFinal(byteContent);
            return Base64.encodeBase64String((byte[])encodeContent);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String encryptStr, String decryptKey) {
        try {
            byte[] raw = decryptKey.getBytes();
            SecretKeySpec skey = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(2, skey);
            byte[] encodeContent = Base64.decodeBase64((String)encryptStr);
            byte[] byteContent = cipher.doFinal(encodeContent);
            return new String(byteContent, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String content) {
        try {
            byte[] raw = sysProperties.getAesKey().getBytes();
            SecretKeySpec skey = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(1, skey);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            byte[] encodeContent = cipher.doFinal(byteContent);
            return Base64.encodeBase64String((byte[])encodeContent);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String encryptStr) {
        try {
            byte[] raw = sysProperties.getAesKey().getBytes();
            SecretKeySpec skey = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(2, skey);
            byte[] encodeContent = Base64.decodeBase64((String)encryptStr);
            byte[] byteContent = cipher.doFinal(encodeContent);
            return new String(byteContent, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }
}

