/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.bootstrap;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.radiationTraining.exception.ServiceException;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

@ControllerAdvice
public class SmarthseExceptionHandler
extends SimpleMappingExceptionResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseData<Object> dealException(Exception ex) {
        List allErrors;
        ResponseData<Object> r = new ResponseData<Object>();
        if (ex instanceof ConstraintViolationException) {
            Set message = ((ConstraintViolationException)ex).getConstraintViolations();
            HashMap map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST);
            r.setMessage(ResponseStateEnum.BAD_REQUEST.getName());
            r.setResult(map);
        } else if (ex instanceof MethodArgumentNotValidException) {
            allErrors = ((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST);
            r.setMessage(ResponseStateEnum.BAD_REQUEST.getName());
            r.setResult(map);
        } else if (ex instanceof BindException) {
            allErrors = ((BindException)ex).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST);
            r.setMessage(ResponseStateEnum.BAD_REQUEST.getName());
            r.setResult(map);
        } else if (ex instanceof UnauthenticatedException) {
            r.setState(ResponseStateEnum.UNAUTHORIZED);
            r.setMessage("\u767b\u5165\u5931\u6548\uff01");
        } else if (ex instanceof AuthorizationException) {
            r.setState(ResponseStateEnum.Unauthorized403);
            r.setMessage("\u65e0\u76f8\u5173\u6743\u9650\uff01");
        } else if (ex instanceof AuthenticationException) {
            r.setState(ResponseStateEnum.fail);
            r.setMessage("\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        } else if (ex instanceof HealthException) {
            ErrorEnum errorEnum = ((HealthException)ex).getError();
            if (Objects.isNull(errorEnum)) {
                r.setState(ResponseStateEnum.fail);
                r.setMessage(ex.getMessage());
            } else {
                Integer code = errorEnum.getCode();
                r.setState(ResponseStateEnum.getState(code == 0 ? 1 : code));
                r.setMessage(ex.getMessage());
            }
        } else if (ex instanceof ServiceException) {
            r.setResult(((ServiceException)ex).getResult());
            r.setState(ResponseStateEnum.getState(((ServiceException)ex).getCode()));
            r.setMessage(ex.getMessage());
        } else if (ex instanceof RpcException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR);
            r.setMessage("RPC\u670d\u52a1\u9519\u8bef\uff01");
        } else if (ex instanceof HttpMessageNotReadableException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR);
            r.setMessage("\u53c2\u6570\u6709\u8bef\uff01");
        } else if (ex instanceof MaxUploadSizeExceededException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR);
            r.setMessage("\u6587\u4ef6\u592a\u5927\uff01");
        } else {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR);
            r.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        try {
            HttpServletRequest request = ServletUtils.getRequest();
            log.error("userId:{}-uri:{}-param:{}-\u7edf\u4e00\u6355\u83b7\u5f02\u5e38=>:", new Object[]{JwtUtil.getUserId(request.getHeader(Constant.TOKEN_HEADER_NAME)), request.getRequestURI(), ServletUtils.getRequestParam(request), ex});
        }
        catch (Exception e) {
            log.error("\u7edf\u4e00\u6355\u83b7\u5f02\u5e38=>:", (Throwable)ex);
        }
        return r;
    }
}

