/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.bootstrap;

import cn.hutool.json.JSONUtil;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
@ConditionalOnProperty(value={"spring.profiles.active"}, havingValue="dev")
@Order(value=1)
public class LogAopAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAopAspect.class);
    private static final String START_TIME = "request-start";
    private static final String REQUEST_METHOD_GET = "GET";

    @Pointcut(value="execution(public * cn.smarthse.radiationTraining..*.controller..*.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            log.debug("\u3010\u8bf7\u6c42URI\u3011\uff1a{}-{}", (Object)request.getRemoteAddr(), (Object)request.getRequestURI());
            this.printParam(point.getArgs(), request.getRequestURL().toString());
            Long start = System.currentTimeMillis();
            request.setAttribute(START_TIME, (Object)start);
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
    }

    @Around(value="pointCut()")
    public Object aroundLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        log.debug("\u3010\u8bf7\u6c42\u8fd4\u56de\u3011\uff1a{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    @AfterReturning(value="pointCut()")
    public void afterReturning() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        log.debug("\u3010\u8bf7\u6c42\u8017\u65f6\u3011\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - (Long)request.getAttribute(START_TIME)));
    }

    private boolean isCommonParam(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof MultipartFile) && !(arg instanceof HttpServletResponse) && !(arg instanceof HttpServletRequest)) continue;
            return false;
        }
        return true;
    }

    private void printParam(Object[] args, String url) {
        if (!this.isCommonParam(args)) {
            return;
        }
        if (url.contains("/login")) {
            return;
        }
        log.debug("\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}", (Object)JSON.toJSONString((Object)args));
    }
}

