/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.utils;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaUtil {
    private static final Logger log = LoggerFactory.getLogger(RsaUtil.class);

    public static Map<String, String> genKeyPair() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException", (Throwable)e);
        }
        keyPairGen.initialize(512, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyStr = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        String privateKeyStr = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        log.debug("\u968f\u673a\u751f\u6210\u7684\u516c\u94a5\u4e3a:" + publicKeyStr);
        log.debug("\u968f\u673a\u751f\u6210\u7684\u79c1\u94a5\u4e3a:" + privateKeyStr);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("publicKey", publicKeyStr);
        result.put("privateKey", privateKeyStr);
        return result;
    }

    public static String encrypt(String content, String publicKey) {
        byte[] data = content.getBytes();
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicK);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return new String(Base64.encodeBase64((byte[])encryptedData));
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String content, String privateKey) {
        byte[] text = Base64.decodeBase64((String)content);
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateK);
            int inputLen = text.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(text, offSet, 256) : cipher.doFinal(text, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return new String(decryptedData);
        }
        catch (Exception e) {
            log.error("Exception:", (Throwable)e);
            return null;
        }
    }
}

