/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.utils;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final float scale = 1.0f;
    private static final long min_size = 102400L;

    public static void writeFromStream(InputStream inputStream, String realPath, float scale) {
        if (realPath.endsWith("jpg") || realPath.endsWith("jpeg") || realPath.endsWith("png") || realPath.endsWith("bmp") || realPath.endsWith("psd")) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(cn.hutool.core.io.FileUtil.touch((String)realPath));
            }
            catch (FileNotFoundException e) {
                log.error("FileNotFoundException\uff1a", (Throwable)e);
            }
            try {
                ImgUtil.scale((InputStream)inputStream, (OutputStream)outputStream, (float)scale);
            }
            catch (Exception e) {
                log.error("\u56fe\u7247\u538b\u7f29\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                cn.hutool.core.io.FileUtil.writeFromStream((InputStream)inputStream, (String)realPath);
            }
            IoUtil.close((Closeable)inputStream);
            IoUtil.close((Closeable)outputStream);
        } else {
            try {
                cn.hutool.core.io.FileUtil.writeFromStream((InputStream)inputStream, (String)realPath);
            }
            catch (IORuntimeException e) {
                log.error("IORuntimeException\uff1a", (Throwable)e);
            }
        }
    }

    public static void writeFromStream(InputStream inputStream, String realPath) {
        FileUtil.writeFromStream(inputStream, realPath, 1.0f);
    }

    public static void writeFromStream(MultipartFile fileData, String realPath) {
        if (fileData.getSize() <= 102400L) {
            try {
                cn.hutool.core.io.FileUtil.writeFromStream((InputStream)fileData.getInputStream(), (String)realPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileUtil.writeFromStream(fileData.getInputStream(), realPath, 1.0f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static float scale200K(long srcSize) {
        float scale = srcSize < 200000L ? 1.0f : (srcSize < 500000L ? 0.57f : (srcSize < 700000L ? 0.47f : (srcSize < 1000000L ? 0.37f : (srcSize < 2000000L ? 0.25f : (srcSize < 4000000L ? 0.17f : (srcSize < 5000000L ? 0.13f : (srcSize < 10000000L ? 0.1f : 0.01f)))))));
        return scale;
    }
}

