/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.uploader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMD5 {
    private static final Logger log = LoggerFactory.getLogger(FileMD5.class);

    public static String getFileMD5(byte[] buffer) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(buffer);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException:", (Throwable)e);
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static String getFileMD5(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException:", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException:", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException:", (Throwable)e);
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static Map<String, String> getDirMD5(File file, boolean listChild) {
        if (!file.isDirectory()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            if (file2.isDirectory() && listChild) {
                map.putAll(FileMD5.getDirMD5(file2, listChild));
                continue;
            }
            String md5 = FileMD5.getFileMD5(file2);
            if (md5 == null) continue;
            map.put(file2.getPath(), md5);
        }
        return map;
    }
}

