/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.logback;

import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveConverter
extends CompositeConverter<Object> {
    private static final String phonePattern = "(?:0|86|\\+86)?1[3-9]\\d{9}";
    private static final String idCardPattern = "\\d{17}[0-9Xx]";
    private static final String emailPattern = "[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}";

    protected String transform(Object event, String in) {
        Matcher matcher = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}|\\d{17}[0-9Xx]|[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}").matcher(in);
        StringBuffer maskedInput = new StringBuffer();
        while (matcher.find()) {
            String matchedString = matcher.group();
            if (matchedString.matches(phonePattern)) {
                matcher.appendReplacement(maskedInput, SensitiveConverter.maskPartialData(matchedString, 3, 7));
                continue;
            }
            if (matchedString.matches(idCardPattern)) {
                matcher.appendReplacement(maskedInput, SensitiveConverter.maskPartialData(matchedString, 6, 14));
                continue;
            }
            if (!matchedString.matches(emailPattern)) continue;
            matcher.appendReplacement(maskedInput, SensitiveConverter.maskEmail(matchedString));
        }
        return matcher.appendTail(maskedInput).toString();
    }

    public static String maskPartialData(String data, int start, int end) {
        StringBuilder maskedData = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            if (i >= start && i < end) {
                maskedData.append('*');
                continue;
            }
            maskedData.append(data.charAt(i));
        }
        return maskedData.toString();
    }

    public static String maskEmail(String email) {
        int atIndex = email.indexOf(64);
        if (atIndex > 0) {
            String username = email.substring(0, atIndex);
            String domain = email.substring(atIndex);
            return SensitiveConverter.maskPartialData(username, 2, username.length()) + domain;
        }
        return email;
    }

    public static String maskChineseName(String name) {
        if (name.length() > 1) {
            String firstName = name.substring(0, 1);
            String maskedName = SensitiveConverter.maskPartialData(name.substring(1), 0, name.length() - 1);
            return firstName + maskedName;
        }
        return name;
    }
}

