/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.config.desensitization;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.smarthse.radiationTraining.core.framework.config.desensitization.Desensitization;
import cn.smarthse.radiationTraining.core.framework.config.desensitization.DesensitizationType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public class DesensitizationSerialize
extends JsonSerializer<String>
implements ContextualSerializer {
    private DesensitizationType type;
    private Integer start;
    private Integer end;

    public DesensitizationSerialize() {
    }

    public DesensitizationSerialize(DesensitizationType type, int start, int end) {
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public void serialize(String str, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        switch (this.type) {
            case CUSTOM_ROLE: {
                gen.writeString(CharSequenceUtil.hide((CharSequence)str, (int)this.start, (int)this.end));
                break;
            }
            case USER_ID: {
                gen.writeString(String.valueOf(DesensitizedUtil.userId()));
                break;
            }
            case CHINESE_NAME: {
                gen.writeString(DesensitizedUtil.chineseName((String)String.valueOf(str)));
                break;
            }
            case ID_CARD: {
                gen.writeString(DesensitizedUtil.idCardNum((String)String.valueOf(str), (int)1, (int)2));
                break;
            }
            case FIXED_PHONE: {
                gen.writeString(DesensitizedUtil.fixedPhone((String)String.valueOf(str)));
                break;
            }
            case MOBILE_PHONE: {
                gen.writeString(DesensitizedUtil.mobilePhone((String)String.valueOf(str)));
                break;
            }
            case ADDRESS: {
                gen.writeString(DesensitizedUtil.address((String)String.valueOf(str), (int)8));
                break;
            }
            case EMAIL: {
                gen.writeString(DesensitizedUtil.email((String)String.valueOf(str)));
                break;
            }
            case PASSWORD: {
                gen.writeString(DesensitizedUtil.password((String)String.valueOf(str)));
                break;
            }
            case CAR_LICENSE: {
                gen.writeString(DesensitizedUtil.carLicense((String)String.valueOf(str)));
                break;
            }
            case BANK_CARD: {
                gen.writeString(DesensitizedUtil.bankCard((String)String.valueOf(str)));
                break;
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty == null) {
            return prov.findNullValueSerializer(null);
        }
        if (!beanProperty.getType().getRawClass().equals(String.class)) {
            return prov.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        Desensitization desensitization = (Desensitization)beanProperty.getAnnotation(Desensitization.class);
        if (desensitization == null) {
            return prov.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return new DesensitizationSerialize(desensitization.type(), desensitization.start(), desensitization.end());
    }
}

