/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.core.framework.bootstrap;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=2)
public class EditParamAopAspect {
    private static final Logger log = LoggerFactory.getLogger(EditParamAopAspect.class);

    @Pointcut(value="execution(public * cn.smarthse.radiationTraining..*.controller..*.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
        this.initUserEditParam(point.getArgs(), ServletUtils.getRequest());
    }

    private void initUserEditParam(Object[] args, HttpServletRequest request) {
        if (args == null) {
            return;
        }
        for (Object arg : args) {
            String token;
            if (!(arg instanceof UserEditParam) || (token = request.getHeader(Constant.TOKEN_HEADER_NAME)) == null || token.isEmpty()) continue;
            ((UserEditParam)arg).setLoginUserId(JwtUtil.getUserId(token));
            ((UserEditParam)arg).setLoginName(JwtUtil.getName(token));
            ((UserEditParam)arg).setLoginUsername(JwtUtil.getUsername(token));
        }
    }
}

