package javax.smarthse.radiationTraining.exception;

import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;

/**
 * 《系统Service统一异常定义》
 * 
 * @author liaoly
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 */
public class ServiceException extends RuntimeException {
	private static final long serialVersionUID = -2437346477531817923L;
	/**
	 * 错误编号
	 */
	private Integer code = 1;
	/**
	 * 数据项
	 */
	private Object result;
	
	public ServiceException() {
		super();
	}

	/**
	 * 默认 code = 1 前端会直接提示message，
	 * 需要前端自定义提示的话code=-1,
	 * 或者自行编码并补全 {@link ResponseStateEnum}
	 */
	public ServiceException(String message) {
		super(message);
	}

	/**
	 * 需要前端自定义提示的话code=-1，
	 * 有多种情况的话，自行编码配合前端提示 {@link ResponseStateEnum}
	 */
	public ServiceException(Integer code, String message) {
		super(message);
		this.code = code;
	}

	/**
	 * 需要前端自定义提示的话code=-1，
	 * 有多种情况的话，自行编码配合前端提示 {@link ResponseStateEnum}
	 */
	public ServiceException(Integer code, String message, Object result) {
		super(message);
		this.code = code;
		this.result = result;
	}
	
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}

	public Object getResult() {
		return result;
	}
	public void setResult(Object result) {
		this.result = result;
	}
}
