//package cn.smarthse.radiationTraining.core.framework.utils;
//
//import com.itextpdf.kernel.pdf.PdfArray;
//import com.itextpdf.kernel.pdf.PdfName;
//import com.itextpdf.kernel.pdf.PdfNumber;
//import com.itextpdf.kernel.pdf.PdfReader;
//import com.itextpdf.text.Document;
//import com.itextpdf.text.DocumentException;
//import com.itextpdf.text.Image;
//import com.itextpdf.text.Rectangle;
//import com.itextpdf.text.pdf.*;
//import org.apache.pdfbox.pdmodel.PDDocument;
//import org.apache.pdfbox.rendering.PDFRenderer;
//
//import javax.imageio.ImageIO;
//import javax.servlet.ServletOutputStream;
//import java.awt.image.BufferedImage;
//import java.io.ByteArrayOutputStream;
//import java.io.File;
//import java.io.FileOutputStream;
//import java.io.IOException;
//import java.util.ArrayList;
//import java.util.Map;
//
///**
// * @ClassName PdfUtils
// * @Description pdf生成工具类
// * @Author Wuxq
// * @Date 2022/4/13
// */
//public class PdfUtils {
//
//    private final Logger logger = LogFactory.getLogger(this.getClass());
//
//    /**
//     * 方法描述:  根据模板生成PDF File
//     *
//     * @param mMapDatas           模板数据
//     * @param tPdfTemplateFileUrl 模板文件url
//     * @param tPdfResultFileUrl   生成的PDF文件url
//     * @return File pdf文件
//     * @author wuxq
//     * @date 2022/4/15
//     */
//    public File fillFormDatas(Map<String, Object> mMapDatas, String tPdfTemplateFileUrl, String tPdfResultFileUrl) throws Exception {
//
//        File outFile = null;
//        FileOutputStream fos;
//        PdfReader reader;
//        PdfStamper mPdfStamper;
//        try {
//            // 可以使用getChineseFont
//
//            // 读取pdf模板
//            outFile = new File(tPdfResultFileUrl);
//            // 如果不存在临时文件夹，则创建文件夹
//            if (!outFile.getParentFile().exists()) {
//                outFile.getParentFile().mkdirs();
//            }
//            logger.debug("临时文件所在位置：" + outFile.getPath());
//
//            // 解析PDF模板
//            fos = new FileOutputStream(outFile);   // 需要生成PDF
//            reader = new PdfReader(tPdfTemplateFileUrl);  // 模板
//            mPdfStamper = new PdfStamper(reader, fos);   // 解析
//            mPdfStamper.setFormFlattening(true);
//            // 获取到模板上预定义的参数域
//            AcroFields form = mPdfStamper.getAcroFields();
//            // 循环解析模板定义的表单域
//            for (String name : form.getFields().keySet()) {
//
//                String value = mMapDatas.get(name) != null ? mMapDatas.get(name).toString() : null;
//                if (StringUtils.isNotEmpty(value) && (name.contains("img") || name.contains("Img")
//                        || name.contains("image") || name.contains("Image"))) {
//                    int pageNo = form.getFieldPositions(name).get(0).page;
//                    Rectangle signRect = form.getFieldPositions(name).get(0).position;
//                    float x = signRect.getLeft();
//                    float y = signRect.getBottom();
//                    //根据路径读取图片
//                    Image image = Image.getInstance(value);
//                    //获取图片页面
//                    PdfContentByte under = mPdfStamper.getOverContent(pageNo);
//                    //图片大小自适应
//                    image.scaleToFit(signRect.getWidth(), signRect.getHeight());
//                    //添加图片
//                    image.setAbsolutePosition(x, y);
//                    under.addImage(image);
//                } else {
//                    if (StringUtils.isNotEmpty(value)) {
//                        if(StringUtils.isNotEmpty(value) && name.contains("trainingContent")){
//                            float textBoxHeight = getDiffHeight(value, name, form);
//                            PdfArray rect1 = form.getFieldItem(name).getValue(0).getAsArray(PdfName.RECT);
//                            rect1.set(3, new PdfNumber(rect1.getAsNumber(3).intValue() + textBoxHeight));
//                        }
//                        form.setField(name, value);
//
//                    }
//                }
//            }
//            // 模板中的变量赋值之后不能编辑
//            mPdfStamper.setFormFlattening(true);
//            mPdfStamper.close();
//            reader.close();
//
//            logger.debug("PDF文档填充生成成功！");
//        } catch (Exception e) {
//            logger.error("PDF文档填充生成失败！", e);
//        }
//
//        return outFile;
//    }
//
//
//    public static float getDiffHeight(String addr, String fileName, AcroFields form) throws IOException, DocumentException {
//        float fontSize = 12f;
//        boolean flag = false;
//        BaseFont baseFont = BaseFont.createFont("STSongStd-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
//        float textWidth = baseFont.getWidthPoint(addr, fontSize);
//        //每行长度
//        float rowLength = (fontSize + 2) * 16;
//        //每行高度
//        float rowHeight = 14;
//        //需要行数
//        int lineCount = Double.valueOf(Math.ceil(textWidth * 1.0 /rowLength)).intValue();
//        if(lineCount > 3){//最大只允许三行
//            lineCount = 3;
//        }
//        //获取域高度
//        Rectangle position = form.getFieldPositions(fileName).get(0).position;
//        float textBoxHeight = position.getHeight();
//
//        return rowHeight * lineCount - textBoxHeight;
//    }
//
//
//    /**
//     * 方法描述:             根据模板生成导出PDF
//     *
//     * @param o            写入的数据
//     * @param out          自定义保存pdf的文件流
//     * @param templatePath pdf模板路径
//     */
//    public void fillTemplate(Map<String, Object> o, ServletOutputStream out, String templatePath) {
//        PdfReader reader;
//        ByteArrayOutputStream bos;
//        PdfStamper stamper;
//        try {
//            // 可以使用getChineseFont
//            //此处的字体,服务要是在linux上,中文会出现导出填不上的情况,所以,此处字体必填
//            BaseFont bf = BaseFont.createFont("/templates/STSONG.TTF", BaseFont.IDENTITY_H, BaseFont.EMBEDDED);
//
//            // 读取pdf模板
//            reader = new PdfReader(templatePath);
//            bos = new ByteArrayOutputStream();
//
//            stamper = new PdfStamper(reader, bos);
//            AcroFields form = stamper.getAcroFields();
//
//            ArrayList<BaseFont> fontList = new ArrayList<BaseFont>();
//            fontList.add(bf);
//            form.setSubstitutionFonts(fontList);
//
//            for (String name : form.getFields().keySet()) {
//                String value = o.get(name) != null ? o.get(name).toString() : null;
//                logger.debug("名字:{},标签:{}", value, name);
//                if (value != null && name.contains("img")) {
//                    int pageNo = form.getFieldPositions(name).get(0).page;
//                    Rectangle signRect = form.getFieldPositions(name).get(0).position;
//                    float x = signRect.getLeft();
//                    float y = signRect.getBottom();
//                    //根据路径读取图片
//                    Image image = Image.getInstance(value);
//                    //获取图片页面
//                    PdfContentByte under = stamper.getOverContent(pageNo);
//                    //图片大小自适应
//                    image.scaleToFit(signRect.getWidth(), signRect.getHeight());
//                    //添加图片
//                    image.setAbsolutePosition(x, y);
//                    under.addImage(image);
//                } else {
//                    form.setField(name, value);
//                }
//            }
//
//            // 如果为false那么生成的PDF文件还能编辑，一定要设为true
//            stamper.setFormFlattening(true);
//            stamper.close();
//            Document doc = new Document();
//            PdfCopy copy = new PdfCopy(doc, out);
//            doc.open();
//            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
//            copy.addPage(importPage);
//            doc.close();
//
//            logger.debug("PDF文档填充成功！");
//
//        } catch (IOException | DocumentException e) {
//            logger.error("利用模板导出PDF失败:", e);
//        }
//    }
//
//    /**
//     * dpi越大转换后越清晰，相对转换速度越慢
//     */
//    private static final Integer DPI = 150;
//
//    /**
//     * 转换后的图片类型
//     */
//    private static final String IMG_TYPE = "png";
//
//    /***
//     * PDF文件转PNG图片，全部页数
//     *
//     * @param PdfFilePath pdf完整路径
//     * @return
//     */
//    public File pdf2Image(String PdfFilePath, String dstImgFolder) {
//        // 读取pdf文件
//        File file = new File(PdfFilePath);
//        PDDocument pdDocument;
//        File outFile = null;
//        try {
//            String imgPDFPath = file.getParent();
//            int dot = file.getName().lastIndexOf('.');
//            String imagePDFName = file.getName().substring(0, dot); // 获取图片文件名
//            String imgFolderPath = null;
//            if (dstImgFolder.equals("")) {
//                imgFolderPath = imgPDFPath;// 获取图片存放的文件夹路径
//            } else {
//                imgFolderPath = dstImgFolder;
//            }
//
//            if (createDirectory(imgFolderPath)) {
//
//                pdDocument = PDDocument.load(file);
//                PDFRenderer renderer = new PDFRenderer(pdDocument);
//                /* dpi越大转换后越清晰，相对转换速度越慢 */
//                PdfReader reader = new PdfReader(PdfFilePath);
//                int pages = reader.getNumberOfPages();
//                StringBuilder imgFilePath = null;
//                for (int i = 0; i < pages; i++) {
//                    String imgFilePathPrefix = imgFolderPath + File.separator + imagePDFName;
//                    imgFilePath = new StringBuilder();
//                    imgFilePath.append(imgFilePathPrefix);
//                    imgFilePath.append("_");
//                    imgFilePath.append(i + 1);
//                    imgFilePath.append(".png");
//
//                    outFile = new File(imgFilePath.toString());
//                    BufferedImage image = renderer.renderImageWithDPI(i, DPI);
//                    ImageIO.write(image, "png", outFile);
//
//                }
//                logger.debug("PDF文档转PNG图片成功！");
//
//                reader.close();
//                pdDocument.close();
//            } else {
//                logger.debug("PDF文档转PNG图片失败：" + "创建" + imgFolderPath + "失败");
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//
//        return outFile;
//    }
//
//    private static boolean createDirectory(String folder) {
//        File dir = new File(folder);
//        if (dir.exists()) {
//            return true;
//        } else {
//            return dir.mkdirs();
//        }
//    }
//}
