package cn.smarthse.radiationTraining.core.framework.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 *
 * 获取i18n资源文件
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/12/28 16:00
 */
public class MessageSourceUtil {

	private static final ResourceBundle bundle = ResourceBundle.getBundle("messages_zh_CN", Locale.getDefault());

	/**
	 * 根据消息键和参数 获取消息 委托给spring messageSource
	 * @param code 消息键
	 * @param args 参数
	 * @return 获取国际化翻译值
	 */
	public static String message(String code, Object... args) {

		return MessageFormat.format(bundle.getString(code), args);
	}
}
