package cn.smarthse.radiationTraining.core.framework.utils;

import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;

import java.util.Arrays;

/**
 * @ClassName AccountUtil
 * @Description 账号相关工具
 * @Author ChenLiang
 * @ModifyDate 2022/12/15 14:14
 */

public class AccountUtil {
    /**
     * 判断是否是特殊账号名称
     * @return {@link String}
     * @author chenliang
     * @date 2022/12/15 14:12
     */
    public static boolean isSpecifiedUserName(String username){
        if(StringUtils.isEmpty(username)){
            return false;
        }
        String specifiedUserName = SpringContextHolder.getBean(SysProperties.class).getSpecifiedUser();
        //没有特殊账号设定就默认验证不通过
        if(StringUtils.isEmpty(specifiedUserName)){
            return false;
        }
        //转成大写
        specifiedUserName = specifiedUserName.toUpperCase();
        username = username.toUpperCase();
        //转list
        String[] unameArr = specifiedUserName.split(",");
        //判断
        if(Arrays.asList(unameArr).contains(username)){
            return true;
        }else {
            return false;
        }
    }
    /**
     * 判断是否是超级账号，即拥有最高权限
     * @return {@link String}
     * @author chenliang
     * @date 2022/12/15 14:12
     */
    public static boolean isAdvancedMaintenance(Integer optType,Integer optRole){
        if (optRole != null && optRole != null && optType == 2 && optRole == 0) {
            return true;
        }else {
            return false;
        }
    }
    /**
     * 判断是否是超级账号，即拥有最高权限
     * @return {@link String}
     * @author chenliang
     * @date 2022/12/15 14:12
     */
    public static boolean isGeneralMaintenance(Integer optType,Integer optRole){
        if (optRole != null && optRole != null && optType == 2 && optRole == 0) {
            return true;
        }else {
            return false;
        }
    }
}
