package cn.smarthse.radiationTraining.core.framework.uploader;

import java.io.File;
import javax.servlet.http.HttpServletRequest;

import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

public @Data class UploadFileParameter {

    public static final String FILE_PATH_SEP = System.getProperty("file.separator");

    // 上传路径upload
    public static final String FILE_PATH = "upload" + FILE_PATH_SEP;

    /**
     *
     * @param request HttpServletRequest
     * @param uploadDir 本地相对路径 例如：upload/radiationTraining/common (oss地址与本地临时存储相对位置一致)
     * @param realPath 本地绝对路径 例如：D://data/upload/radiationTraining/common
     * @param fileResource 传文件来源哪个系统 FileResourceEnum 的value
     * @author liaoly
     * @date 2022/9/19 10:11
     */
    public UploadFileParameter(HttpServletRequest request, String uploadDir, String realPath, Integer fileResource) {
        this.request = request;
        this.uploadDir = uploadDir;
        this.realPath = realPath;
        this.fileResource = fileResource;
    }

    public UploadFileParameter() {
    }

    /**
     * 获取上传路径
     *
     * @param f
     * @return String 返回类型
     */
    public static String getUploadFilePath(UploadFilePathEnum f) {
        return FILE_PATH + f.getPath() + FILE_PATH_SEP;
    }

    /**
     * 上传路径 eg: upload/radiationTraining/common
     */
    private String uploadDir;

    /**
     * ossUrl eg: upload/radiationTraining/common/22040102032368.jpg
     */
    private String ossUrl;

    /**
     * oss存储路径 eg: upload/radiationTraining/common
     */
    private String ossDir;

    /**
     * 本地绝对路径地址 eg: D://data/upload/radiationTraining/common
     */
    private String realPath;

    /**
     * 文件上传状态
     * UPLOAD_SUCCSSS(0, "上传文件成功！"),
     * UPLOAD_FAILURE(1, "上传文件失败！"),
     * UPLOAD_TYPE_ERROR(2, "上传文件类型错误！"),
     * UPLOAD_OVERSIZE(3, "上传文件过大！"),
     * UPLOAD_ZEROSIZE(4, "上传文件为空！"),
     * UPLOAD_NOTFOUND(5, "上传文件路径错误！");
     */
    private UploadState uploadState;

    /**
     * 请求request
     */
    private HttpServletRequest request;

    /**
     * 附件表单
     */
    private MultipartFile multipartFile;

    /**
     * 文件名（生成后，一般是UUID）
     */
    private String fileName;


    /**
     * 本地文件名（选取文件时显示）(带扩展名)
     */
    private String originalFilename;

    /**
     * 文件说明（UploadFilePathEnum.desc);
     */
    private String fileDescription;

    /**
     * 本地文件
     */
    private File file;

    /**
     * 源文件扩展名 eg: .JPG
     */
    private String fileExt;

    /**
     * 附件类型
     */
    private Integer type;

    /**
     * 文件大小/B
     */
    private Long filesize;

    /**
     * 文件哈希值
     */
    private String hashCode;

    /**
     * 文件来源fileResourceEnum
     */
    private Integer fileResource;

    /**
     * 上传文件终端ip
     */
    private String ip;
}
