package cn.smarthse.radiationTraining.core.framework.uploader;

/**
 *
 *  传文件来源哪个系统
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 15:44
 */
public enum FileResourceEnum {

	radiation_training(8, "radiationTraining", "放射培训系统"),
	;
	
	/**
	 * key
	 */
	private final int value;
	
	/**
	 * 编码
	 */
	private final String code;
	
	/**
	 * 中文描述
	 */
	private final String name;
	
	FileResourceEnum(int value, String code, String name) {
		
		this.value = value;
		this.code = code;
		this.name = name;
	}

	public int getValue() {
		return value;
	}

	public String getName() {
		return name;
	}
	
	public String getCode() {
		return code;
	}
	
    public static FileResourceEnum getFileResourceEnum(int value){
    	for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
    }
    
    /**
	 * 得到velue的name 
	 * @param value : value
	 * @return String
	 */
	public static String getName(int value) {
		for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	/**
	 * 得到velue的name 
	 * @param value : value
	 * @return String
	 */
	public static String getCode(int value) {
		for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c.code;
			}
		}
		return null;
	}
}
