package cn.smarthse.radiationTraining.core.framework.model;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 *
 * 请求返回标准状态
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/28 13:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ResponseStateEnum {

	/**操作成功*/
	success("操作成功",0),

	/**操作失败*/
	fail("操作失败",1),

	/**操作失败，前端需处理不能直接提示*/
	fail_deal("操作失败，前端处理提示",-1),

	/**警告*/
	warning("警告",2),

	/**请求限制*/
	RequestLimit("请求限制", 3),

	/**400参数不匹配*/
	BAD_REQUEST("400参数不匹配",400),

	/**401登录失效*/
	UNAUTHORIZED("401登录失效",401),

	/**402登录失败*/
	LOGIN_FAIL("402登录失败",402),

	/**403无权限*/
	Unauthorized403("403无权限",403),

	/**500服务器出错*/
	INTERNAL_SERVER_ERROR("500服务器出错",500),

	; 
	
	/**成员变量*/
	private String name;
	private Integer value;

	ResponseStateEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}

	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (ResponseStateEnum c : ResponseStateEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static ResponseStateEnum getState(Integer value) {
		if (value == null) {
			return null;
		}
		for (ResponseStateEnum c : ResponseStateEnum.values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}

}
