package cn.smarthse.radiationTraining.core.framework.model;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 *
 * 基础查询参数对象
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class PageParam extends LayuiGridParam {

    @ApiModelProperty("关键字")
    private String keyword;

    @ApiModelProperty("查询开始日期")
    private Date beginDate;

    @ApiModelProperty("查询结束日期")
    private Date endDate;

    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    @ApiModelProperty(value = "行政区划level", hidden = true)
    private Integer level;

    @ApiModelProperty(value = "行政区划id集合", hidden = true)
    private List<Long> areaIdList;

    public Integer getLevel() {
        return StringUtils.getAreaLevel(this.areaId);
    }
}
