package cn.smarthse.radiationTraining.core.framework.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * 
 * 基础bean
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/12 23:06
 */
@Getter
@Setter
public class BaseBean implements Serializable {
	
	private static final long serialVersionUID = -4646042105629651440L;

	@ApiModelProperty("创建时间")
	private LocalDateTime createDate;

	@ApiModelProperty("更新时间")
	private LocalDateTime updateDate;

	@ApiModelProperty("创建人")
	private Long createBy;

	@ApiModelProperty("更新人")
	private Long updateBy;

	@TableLogic
	@TableField(select = true)
	@ApiModelProperty(value = "是否有效（1-有效；0-无效）")
	private Integer isValid;

}
