package cn.smarthse.radiationTraining.core.framework.logback;

import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * logback 打印日志脱敏过滤器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/8/25 15:25
 */
public class SensitiveConverter extends CompositeConverter<Object> {
    /** 手机号 */
    private static final String phonePattern = "(?:0|86|\\+86)?1[3-9]\\d{9}";
    /** 身份证 */
    private static final String idCardPattern = "\\d{17}[0-9Xx]";
    /** 邮箱 */
    private static final String emailPattern = "[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}";

    @Override
    protected String transform(Object event, String in) {

        // 匹配手机号、身份证号、邮箱的正则表达式
        Matcher matcher = Pattern.compile(phonePattern + "|" + idCardPattern + "|" + emailPattern).matcher(in);

        StringBuffer maskedInput = new StringBuffer();
        while (matcher.find()) {
            String matchedString = matcher.group();
            if (matchedString.matches(phonePattern)) { //匹配手机号
                matcher.appendReplacement(maskedInput, maskPartialData(matchedString, 3, 7));
            } else if (matchedString.matches(idCardPattern)) { //匹配身份证号
                matcher.appendReplacement(maskedInput, maskPartialData(matchedString, 6, 14));
            } else if (matchedString.matches(emailPattern)) { //匹配邮箱
                matcher.appendReplacement(maskedInput, maskEmail(matchedString));
            }
        }

        return matcher.appendTail(maskedInput).toString();
    }

    /**
     * 自定义脱敏 （start 至 end 用 * 替换显示，左闭右开）
     * @param data 数据
     * @param start 开始
     * @param end 结束
     * @return {@link String}
     * @author liaoly
     * @date 2023/8/25 15:27
     */
    public static String maskPartialData(String data, int start, int end) {
        StringBuilder maskedData = new StringBuilder();
        for (int i = 0; i < data.length(); i++) {
            if (i >= start && i < end) {
                maskedData.append('*');
            } else {
                maskedData.append(data.charAt(i));
            }
        }
        return maskedData.toString();
    }

    /**
     * 邮箱脱敏
     * @param email
     * @return {@link String}
     * @author liaoly
     * @date 2023/8/25 15:27
     */
    public static String maskEmail(String email) {
        int atIndex = email.indexOf('@');
        if (atIndex > 0) {
            String username = email.substring(0, atIndex);
            String domain = email.substring(atIndex);
            return maskPartialData(username, 2, username.length()) + domain;
        }
        return email;
    }
    /**
     * 中文姓名脱敏
     * @param name
     * @return {@link String}
     * @author liaoly
     * @date 2023/8/25 15:34
     */
    public static String maskChineseName(String name) {
        if (name.length() > 1) {
            String firstName = name.substring(0, 1);
            String maskedName = maskPartialData(name.substring(1), 0, name.length() - 1);
            return firstName + maskedName;
        }
        return name;
    }

}