package cn.smarthse.radiationTraining.core.framework.interceptor;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 日志操作类型 1-登录日志 2-操作日志 20-添加类型 21-修改类型
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年7月26日 下午2:25:00
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LogTypeEnum {

	/**
	 * 1-登录日志
	 */
	type_login("登录日志", 1), 
	/**
	 * 2-操作日志
	 */
	type_opt("操作日志", 2), 
	/**
	 * 20-添加类型
	 */
	type_opt_add("添加类型", 20), 
	/**
	 * 21-修改类型
	 */
	type_opt_edit("修改类型", 21), 
	/**
	 * 22-删除
	 */
	type_opt_del("删除", 22), 
	/**
	 * 23-导入
	 */
//	type_opt_import("导入", 23),
	/**
	 * 24-导出
	 */
//	type_opt_export("导出", 24),
	/**
	 * 25-下载
	 */
	type_opt_download("下载", 25),
	/**
	 * 26-上传
	 */
	type_opt_upload("上传", 26),
	/**
	 * 27-重置密码
	 */
	type_opt_reset("重置密码", 27),
	
	anon("其他", 0),;
	
	/**
	 * 模块名
	 */
	public String name;
	/**
	 * 模块编码
	 */
	public Integer value;
	// 构造方法
	
	LogTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}

	public static LogTypeEnum getByVlaue(Integer value) {
		for (LogTypeEnum c : LogTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return LogTypeEnum.anon;
	}

	public static String getNameByVlaue(Integer value) {
		
		return getByVlaue(value).getName();
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}
