package cn.smarthse.radiationTraining.core.framework.interceptor;

import java.lang.annotation.*;

/**
 *
 * 方法级日志拦截器标识
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/26 20:21
 */
@Target({ElementType.METHOD})  
@Documented  
@Retention(RetentionPolicy.RUNTIME)
public @interface Log {

	/**
	 *
	 * 标题
	 * @author liaoly(廖凌云) [1302013247@qq.com]
	 * @date 2022/2/26 20:22
	 */
	String title() default "";

	/**
	 * 日志模块
	 * @return {@link LogModuleTypeEnum}
	 * @author liaoly
	 * @date 2022/3/21 11:00
	 */
	LogModuleTypeEnum logModule() default  LogModuleTypeEnum.anon;

	/**
	 *
	 * 操作类型
	 * @author liaoly(廖凌云) [1302013247@qq.com]
	 * @date 2022/2/26 20:21
	 */
	LogTypeEnum type() default LogTypeEnum.type_opt;
	/**
	 *
	 * 模块名
	 * @author liaoly(廖凌云) [1302013247@qq.com]
	 * @date 2022/2/26 20:22
	 */
	@Deprecated
	LogConstans module() default LogConstans.anon;

}
