package cn.smarthse.radiationTraining.core.framework.filter;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 请求体过滤器.
 * <p>
 * 将请求体由 <code>HttpServletRequest</code> 类型替换为自定义 <code>MultiReadHttpServletRequest</code>
 * 类型，实现请求体 <code>RequestBody</code> 的多次读取.
 *
 * @author <a href="mailto:xiaoQQya@126.com">xiaoQQya</a>
 * @date 2021/05/06
 * @since 1.0
 */
@WebFilter(
        filterName = "MultiReadHttpServletRequestFilter"
)
public class MultiReadHttpServletRequestFilter implements Filter {

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ServletRequest multiReadRequest = null;
        String contentType = servletRequest.getContentType();

        if (contentType != null && contentType.startsWith("application/json")
                && servletRequest instanceof HttpServletRequest) {
            multiReadRequest = new MultiReadHttpServletRequest((HttpServletRequest) servletRequest);
        }
        if (multiReadRequest == null) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter(multiReadRequest, servletResponse);
        }
    }
}
